/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.ConfigDefinition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.ColumnFilterMode;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalDatabaseConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Selectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Tables;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.DatabaseHistory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.DatabaseHistoryMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.HistoryRecordComparator;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.KafkaDatabaseHistory;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceConnector;

public abstract class HistorizedRelationalDatabaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 2000;
    private boolean useCatalogBeforeSchema;
    private final String logicalName;
    private final Class<? extends SourceConnector> connectorClass;
    public static final Field DATABASE_HISTORY = Field.create("database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().history(DATABASE_HISTORY, DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, DatabaseHistory.STORE_ONLY_MONITORED_TABLES_DDL, DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS).create();

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, boolean useCatalogBeforeSchema, int defaultSnapshotFetchSize, ColumnFilterMode columnFilterMode) {
        super(config, logicalName, systemTablesFilter, TableId::toString, defaultSnapshotFetchSize, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
    }

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, boolean useCatalogBeforeSchema, ColumnFilterMode columnFilterMode) {
        this(connectorClass, config, logicalName, systemTablesFilter, useCatalogBeforeSchema, 2000, columnFilterMode);
    }

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, boolean useCatalogBeforeSchema, ColumnFilterMode columnFilterMode) {
        super(config, logicalName, systemTablesFilter, tableIdMapper, 2000, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
    }

    public DatabaseHistory getDatabaseHistory() {
        Configuration config = this.getConfig();
        DatabaseHistory databaseHistory = config.getInstance(DATABASE_HISTORY, DatabaseHistory.class);
        if (databaseHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, this.getLogicalName() + "-dbhistory")).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_CLASS, this.connectorClass.getName())).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_ID, this.logicalName)).build();
        HistoryRecordComparator historyComparator = this.getHistoryRecordComparator();
        databaseHistory.configure(dbHistoryConfig, historyComparator, new DatabaseHistoryMetrics(this), this.useCatalogBeforeSchema);
        return databaseHistory;
    }

    public boolean useCatalogBeforeSchema() {
        return this.useCatalogBeforeSchema;
    }

    protected abstract HistoryRecordComparator getHistoryRecordComparator();
}

