/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.Immutable;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.ThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.ValueConverter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.spi.converter.ConvertedField;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.spi.converter.CustomConverter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.spi.converter.RelationalColumn;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;

@ThreadSafe
public class CustomConverterRegistry {
    @Immutable
    private final List<CustomConverter<SchemaBuilder, ConvertedField>> converters;
    private final Map<String, ConverterDefinition<SchemaBuilder>> conversionFunctionMap = new HashMap<String, ConverterDefinition<SchemaBuilder>>();

    public CustomConverterRegistry(List<CustomConverter<SchemaBuilder, ConvertedField>> converters) {
        this.converters = converters == null ? Collections.emptyList() : Collections.unmodifiableList(converters);
    }

    public synchronized Optional<SchemaBuilder> registerConverterFor(final TableId table, final Column column) {
        String fullColumnName = this.fullColumnName(table, column);
        for (CustomConverter<SchemaBuilder, ConvertedField> converter : this.converters) {
            final AtomicReference definition = new AtomicReference();
            converter.converterFor(new RelationalColumn(){

                @Override
                public String name() {
                    return column.name();
                }

                @Override
                public String dataCollection() {
                    return table.toString();
                }

                @Override
                public String typeName() {
                    return column.typeName();
                }

                @Override
                public String typeExpression() {
                    return column.typeExpression();
                }

                @Override
                public OptionalInt scale() {
                    return column.scale().isPresent() ? OptionalInt.of(column.scale().get()) : OptionalInt.empty();
                }

                @Override
                public int nativeType() {
                    return column.nativeType();
                }

                @Override
                public OptionalInt length() {
                    return column.length() == -1 ? OptionalInt.empty() : OptionalInt.of(column.length());
                }

                @Override
                public int jdbcType() {
                    return column.jdbcType();
                }

                @Override
                public boolean isOptional() {
                    return column.isOptional();
                }

                @Override
                public boolean hasDefaultValue() {
                    return column.hasDefaultValue();
                }

                @Override
                public Object defaultValue() {
                    return column.defaultValue();
                }
            }, new CustomConverter.ConverterRegistration<SchemaBuilder>(){

                @Override
                public void register(SchemaBuilder fieldSchema, CustomConverter.Converter converter) {
                    definition.set(new ConverterDefinition<SchemaBuilder>(fieldSchema, converter));
                }
            });
            if (definition.get() == null) continue;
            this.conversionFunctionMap.put(fullColumnName, (ConverterDefinition)definition.get());
            return Optional.of((SchemaBuilder)((ConverterDefinition)definition.get()).fieldSchema);
        }
        this.conversionFunctionMap.remove(fullColumnName);
        return Optional.empty();
    }

    public Optional<ValueConverter> getValueConverter(TableId table, Column column) {
        ConverterDefinition<SchemaBuilder> converterDefinition = this.conversionFunctionMap.get(this.fullColumnName(table, column));
        if (converterDefinition == null) {
            return Optional.empty();
        }
        return Optional.of(x -> converterDefinition.converter.convert(x));
    }

    private String fullColumnName(TableId table, Column column) {
        return table + "." + column.name();
    }

    public class ConverterDefinition<S> {
        public final S fieldSchema;
        public final CustomConverter.Converter converter;

        public ConverterDefinition(S fieldSchema, CustomConverter.Converter converter) {
            this.fieldSchema = fieldSchema;
            this.converter = converter;
        }
    }
}

