/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental;

import java.sql.SQLException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.NotThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.jdbc.JdbcConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.DataChangeEventListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.SnapshotProgressListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.Partition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DataCollectionId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SignalBasedIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
extends AbstractIncrementalSnapshotChangeEventSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignalBasedIncrementalSnapshotChangeEventSource.class);
    private final String signalWindowStatement;

    public SignalBasedIncrementalSnapshotChangeEventSource(CommonConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<T> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
        this.signalWindowStatement = "INSERT INTO " + this.getSignalTableName(config.getSignalingDataCollectionId()) + " VALUES (?, ?, null)";
    }

    @Override
    public void processMessage(Partition partition, DataCollectionId dataCollectionId, Object key, OffsetContext offsetContext) {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (this.context == null) {
            LOGGER.warn("Context is null, skipping message processing");
            return;
        }
        LOGGER.trace("Checking window for table '{}', key '{}', window contains '{}'", new Object[]{dataCollectionId, key, this.window});
        if (!this.window.isEmpty() && this.context.deduplicationNeeded()) {
            this.deduplicateWindow(dataCollectionId, key);
        }
    }

    @Override
    protected void emitWindowOpen() throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            LOGGER.trace("Emitting open window for chunk = '{}'", (Object)this.context.currentChunkId());
            x.setString(1, this.context.currentChunkId() + "-open");
            x.setString(2, "snapshot-window-open");
        });
        this.jdbcConnection.commit();
    }

    @Override
    protected void emitWindowClose() throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            LOGGER.trace("Emitting close window for chunk = '{}'", (Object)this.context.currentChunkId());
            x.setString(1, this.context.currentChunkId() + "-close");
            x.setString(2, "snapshot-window-close");
        });
        this.jdbcConnection.commit();
    }
}

