/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.NotThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.jdbc.JdbcConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.DataChangeEventListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.SnapshotProgressListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.ChangeRecordEmitter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.Partition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Column;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.SnapshotChangeRecordEmitter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DataCollectionId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.ColumnUtils;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Threads;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractIncrementalSnapshotChangeEventSource<T extends DataCollectionId>
implements IncrementalSnapshotChangeEventSource<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIncrementalSnapshotChangeEventSource.class);
    private final CommonConnectorConfig connectorConfig;
    private final Clock clock;
    private final RelationalDatabaseSchema databaseSchema;
    private final SnapshotProgressListener progressListener;
    private final DataChangeEventListener dataListener;
    private long totalRowsScanned = 0L;
    private Table currentTable;
    protected EventDispatcher<T> dispatcher;
    protected IncrementalSnapshotContext<T> context = null;
    protected JdbcConnection jdbcConnection;
    protected final Map<Struct, Object[]> window = new LinkedHashMap<Struct, Object[]>();

    public AbstractIncrementalSnapshotChangeEventSource(CommonConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<T> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        this.connectorConfig = config;
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.databaseSchema = (RelationalDatabaseSchema)databaseSchema;
        this.clock = clock;
        this.progressListener = progressListener;
        this.dataListener = dataChangeEventListener;
    }

    @Override
    public void closeWindow(Partition partition, String id, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.closeWindow(id)) {
            return;
        }
        this.sendWindowEvents(partition, offsetContext);
        this.readChunk();
    }

    protected String getSignalTableName(String dataCollectionId) {
        return dataCollectionId;
    }

    protected void sendWindowEvents(Partition partition, OffsetContext offsetContext) throws InterruptedException {
        LOGGER.debug("Sending {} events from window buffer", (Object)this.window.size());
        offsetContext.incrementalSnapshotEvents();
        for (Object[] row : this.window.values()) {
            this.sendEvent(partition, this.dispatcher, offsetContext, row);
        }
        offsetContext.postSnapshotCompletion();
        this.window.clear();
    }

    protected void sendEvent(Partition partition, EventDispatcher<T> dispatcher, OffsetContext offsetContext, Object[] row) throws InterruptedException {
        this.context.sendEvent(this.keyFromRow(row));
        offsetContext.event((DataCollectionId)this.context.currentDataCollectionId(), this.clock.currentTimeAsInstant());
        dispatcher.dispatchSnapshotEvent((DataCollectionId)this.context.currentDataCollectionId(), this.getChangeRecordEmitter(partition, (DataCollectionId)this.context.currentDataCollectionId(), offsetContext, row), dispatcher.getIncrementalSnapshotChangeEventReceiver(this.dataListener));
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(Partition partition, T dataCollectionId, OffsetContext offsetContext, Object[] row) {
        return new SnapshotChangeRecordEmitter(partition, offsetContext, row, this.clock);
    }

    protected void deduplicateWindow(DataCollectionId dataCollectionId, Object key) {
        if (!((DataCollectionId)this.context.currentDataCollectionId()).equals(dataCollectionId)) {
            return;
        }
        if (key instanceof Struct && this.window.remove((Struct)key) != null) {
            LOGGER.info("Removed '{}' from window", key);
        }
    }

    protected abstract void emitWindowOpen() throws SQLException;

    protected abstract void emitWindowClose() throws SQLException, InterruptedException;

    protected String buildChunkQuery(Table table) {
        String condition = null;
        if (this.context.isNonInitialChunk()) {
            StringBuilder sql = new StringBuilder();
            this.addKeyColumnsToCondition(table, sql, " >= ?");
            sql.append(" AND NOT (");
            this.addKeyColumnsToCondition(table, sql, " = ?");
            sql.append(")");
            sql.append(" AND ");
            this.addKeyColumnsToCondition(table, sql, " <= ?");
            condition = sql.toString();
        }
        String orderBy = table.primaryKeyColumns().stream().map(Column::name).collect(Collectors.joining(", "));
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), this.connectorConfig.getIncrementalSnashotChunkSize(), "*", Optional.ofNullable(condition), orderBy);
    }

    protected String buildMaxPrimaryKeyQuery(Table table) {
        String orderBy = table.primaryKeyColumns().stream().map(Column::name).collect(Collectors.joining(" DESC, ")) + " DESC";
        return this.jdbcConnection.buildSelectWithRowLimits(table.id(), 1, "*", Optional.empty(), orderBy);
    }

    @Override
    public void init(OffsetContext offsetContext) {
        if (offsetContext == null) {
            LOGGER.info("Empty incremental snapshot change event source started, no action needed");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        this.context = offsetContext.getIncrementalSnapshotContext();
        if (!this.context.snapshotRunning()) {
            LOGGER.info("No incremental snapshot in progress, no action needed on start");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        LOGGER.info("Incremental snapshot in progress, need to read new chunk on start");
        try {
            this.progressListener.snapshotStarted();
            this.readChunk();
        }
        catch (InterruptedException e) {
            throw new DebeziumException("Reading of an initial chunk after connector restart has been interrupted");
        }
        LOGGER.info("Incremental snapshot in progress, loading of initial chunk completed");
    }

    protected void readChunk() throws InterruptedException {
        if (!this.context.snapshotRunning()) {
            LOGGER.info("Skipping read chunk because snapshot is not running");
            this.postIncrementalSnapshotCompleted();
            return;
        }
        try {
            this.jdbcConnection.commit();
            this.preReadChunk(this.context);
            this.context.startNewChunk();
            this.emitWindowOpen();
            while (this.context.snapshotRunning()) {
                TableId currentTableId = (TableId)this.context.currentDataCollectionId();
                this.currentTable = this.databaseSchema.tableFor(currentTableId);
                if (this.currentTable == null) {
                    LOGGER.warn("Schema not found for table '{}', known tables {}", (Object)currentTableId, this.databaseSchema.tableIds());
                    this.nextDataCollection();
                    continue;
                }
                if (this.currentTable.primaryKeyColumns().isEmpty()) {
                    LOGGER.warn("Incremental snapshot for table '{}' skipped cause the table has no primary keys", (Object)currentTableId);
                    this.nextDataCollection();
                    continue;
                }
                if (!this.context.maximumKey().isPresent()) {
                    this.context.maximumKey(this.jdbcConnection.queryAndMap(this.buildMaxPrimaryKeyQuery(this.currentTable), rs -> {
                        if (!rs.next()) {
                            return null;
                        }
                        return this.keyFromRow(this.jdbcConnection.rowToArray(this.currentTable, this.databaseSchema, rs, ColumnUtils.toArray(rs, this.currentTable)));
                    }));
                    if (!this.context.maximumKey().isPresent()) {
                        LOGGER.info("No maximum key returned by the query, incremental snapshotting of table '{}' finished as it is empty", (Object)currentTableId);
                        this.nextDataCollection();
                        continue;
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Incremental snapshot for table '{}' will end at position {}", (Object)currentTableId, (Object)this.context.maximumKey().orElse(new Object[0]));
                    }
                }
                this.createDataEventsForTable();
                if (!this.window.isEmpty()) break;
                LOGGER.info("No data returned by the query, incremental snapshotting of table '{}' finished", (Object)currentTableId);
                this.tableScanCompleted();
                this.nextDataCollection();
            }
            this.emitWindowClose();
        }
        catch (SQLException e) {
            throw new DebeziumException(String.format("Database error while executing incremental snapshot for table '%s'", this.context.currentDataCollectionId()), e);
        }
        finally {
            this.postReadChunk(this.context);
            if (!this.context.snapshotRunning()) {
                this.postIncrementalSnapshotCompleted();
            }
        }
    }

    private void nextDataCollection() {
        this.context.nextDataCollection();
        if (!this.context.snapshotRunning()) {
            this.progressListener.snapshotCompleted();
        }
    }

    @Override
    public void addDataCollectionNamesToSnapshot(List<String> dataCollectionIds, OffsetContext offsetContext) throws InterruptedException {
        this.context = offsetContext.getIncrementalSnapshotContext();
        boolean shouldReadChunk = !this.context.snapshotRunning();
        List<T> newDataCollectionIds = this.context.addDataCollectionNamesToSnapshot(dataCollectionIds);
        if (shouldReadChunk) {
            this.progressListener.snapshotStarted();
            this.progressListener.monitoredDataCollectionsDetermined(newDataCollectionIds);
            this.readChunk();
        }
    }

    protected void addKeyColumnsToCondition(Table table, StringBuilder sql, String predicate) {
        Iterator<Column> i = table.primaryKeyColumns().iterator();
        while (i.hasNext()) {
            Column key = i.next();
            sql.append(key.name()).append(predicate);
            if (!i.hasNext()) continue;
            sql.append(" AND ");
        }
    }

    private void createDataEventsForTable() {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.debug("Exporting data chunk from table '{}' (total {} tables)", (Object)this.currentTable.id(), (Object)this.context.tablesToBeSnapshottedCount());
        String selectStatement = this.buildChunkQuery(this.currentTable);
        LOGGER.debug("\t For table '{}' using select statement: '{}', key: '{}', maximum key: '{}'", new Object[]{this.currentTable.id(), selectStatement, this.context.chunkEndPosititon(), this.context.maximumKey().get()});
        TableSchema tableSchema = this.databaseSchema.schemaFor(this.currentTable.id());
        try (PreparedStatement statement = this.readTableChunkStatement(selectStatement);
             ResultSet rs = statement.executeQuery();){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, this.currentTable);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            Object[] lastRow = null;
            Object[] firstRow = null;
            while (rs.next()) {
                ++rows;
                Object[] row = this.jdbcConnection.rowToArray(this.currentTable, this.databaseSchema, rs, columnArray);
                if (firstRow == null) {
                    firstRow = row;
                }
                Struct keyStruct = tableSchema.keyFromColumnData(row);
                this.window.put(keyStruct, row);
                if (logTimer.expired()) {
                    long stop = this.clock.currentTimeInMillis();
                    LOGGER.debug("\t Exported {} records for table '{}' after {}", new Object[]{rows, this.currentTable.id(), Strings.duration(stop - exportStart)});
                    logTimer = this.getTableScanLogTimer();
                }
                lastRow = row;
            }
            Object[] firstKey = this.keyFromRow(firstRow);
            Object[] lastKey = this.keyFromRow(lastRow);
            if (this.context.isNonInitialChunk()) {
                this.progressListener.currentChunk(this.context.currentChunkId(), firstKey, lastKey);
            } else {
                this.progressListener.currentChunk(this.context.currentChunkId(), firstKey, lastKey, this.context.maximumKey().orElse(null));
            }
            this.context.nextChunkPosition(lastKey);
            if (lastRow != null) {
                LOGGER.debug("\t Next window will resume from '{}'", this.context.chunkEndPosititon());
            }
            LOGGER.debug("\t Finished exporting {} records for window of table table '{}'; total duration '{}'", new Object[]{rows, this.currentTable.id(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.incrementTableRowsScanned(rows);
        }
        catch (SQLException e) {
            throw new DebeziumException("Snapshotting of table " + this.currentTable.id() + " failed", e);
        }
    }

    private void incrementTableRowsScanned(long rows) {
        this.totalRowsScanned += rows;
        this.progressListener.rowsScanned(this.currentTable.id(), this.totalRowsScanned);
    }

    private void tableScanCompleted() {
        this.progressListener.dataCollectionSnapshotCompleted(this.currentTable.id(), this.totalRowsScanned);
        this.totalRowsScanned = 0L;
        this.progressListener.currentChunk(null, null, null, null);
    }

    protected PreparedStatement readTableChunkStatement(String sql) throws SQLException {
        PreparedStatement statement = this.jdbcConnection.readTablePreparedStatement(this.connectorConfig, sql, OptionalLong.empty());
        if (this.context.isNonInitialChunk()) {
            Object[] maximumKey = this.context.maximumKey().get();
            Object[] chunkEndPosition = this.context.chunkEndPosititon();
            for (int i = 0; i < chunkEndPosition.length; ++i) {
                statement.setObject(i + 1, chunkEndPosition[i]);
                statement.setObject(i + 1 + chunkEndPosition.length, chunkEndPosition[i]);
                statement.setObject(i + 1 + 2 * chunkEndPosition.length, maximumKey[i]);
            }
        }
        return statement;
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, RelationalSnapshotChangeEventSource.LOG_INTERVAL);
    }

    private Object[] keyFromRow(Object[] row) {
        if (row == null) {
            return null;
        }
        List<Column> keyColumns = this.currentTable.primaryKeyColumns();
        Object[] key = new Object[keyColumns.size()];
        for (int i = 0; i < keyColumns.size(); ++i) {
            key[i] = row[keyColumns.get(i).position() - 1];
        }
        return key;
    }

    protected void setContext(IncrementalSnapshotContext<T> context) {
        this.context = context;
    }

    protected void preReadChunk(IncrementalSnapshotContext<T> context) {
        try {
            if (!this.jdbcConnection.isValid()) {
                this.jdbcConnection.connect();
            }
        }
        catch (SQLException e) {
            throw new DebeziumException("Database error while checking jdbcConnection in preReadChunk", e);
        }
    }

    protected void postReadChunk(IncrementalSnapshotContext<T> context) {
    }

    protected void postIncrementalSnapshotCompleted() {
    }
}

