/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.metrics;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.ThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.base.ChangeEventQueueMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.common.CdcSourceTaskContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.ConnectorEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.metrics.PipelineMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.metrics.StreamingChangeEventSourceMetricsMXBean;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.DataChangeEventListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.EventMetadataProvider;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DataCollectionId;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamingChangeEventSourceMetrics
extends PipelineMetrics
implements StreamingChangeEventSourceMetricsMXBean,
DataChangeEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingChangeEventSourceMetrics.class);
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicReference<Duration> lagBehindSource = new AtomicReference();
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicReference<Map<String, String>> sourceEventPosition = new AtomicReference(Collections.emptyMap());
    private final AtomicReference<String> lastTransactionId = new AtomicReference();

    public <T extends CdcSourceTaskContext> StreamingChangeEventSourceMetrics(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        super(taskContext, "streaming", changeEventQueueMetrics, metadataProvider);
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    @Deprecated
    public String[] getMonitoredTables() {
        return this.taskContext.capturedDataCollections();
    }

    @Override
    public String[] getCapturedTables() {
        return this.taskContext.capturedDataCollections();
    }

    public void connected(boolean connected) {
        this.connected.set(connected);
        LOGGER.info("Connected metrics set to '{}'", (Object)this.connected.get());
    }

    @Override
    public Map<String, String> getSourceEventPosition() {
        return this.sourceEventPosition.get();
    }

    @Override
    public long getMilliSecondsBehindSource() {
        Duration lag = this.lagBehindSource.get();
        return lag != null ? lag.toMillis() : -1L;
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public void onEvent(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        Map<String, String> eventSource;
        String transactionId;
        super.onEvent(source, offset, key, value);
        Instant eventTimestamp = this.metadataProvider.getEventTimestamp(source, offset, key, value);
        if (eventTimestamp != null) {
            this.lagBehindSource.set(Duration.between(eventTimestamp, Instant.now()));
        }
        if ((transactionId = this.metadataProvider.getTransactionId(source, offset, key, value)) != null && !transactionId.equals(this.lastTransactionId.get())) {
            this.lastTransactionId.set(transactionId);
            this.numberOfCommittedTransactions.incrementAndGet();
        }
        if ((eventSource = this.metadataProvider.getEventSourcePosition(source, offset, key, value)) != null) {
            this.sourceEventPosition.set(eventSource);
        }
    }

    @Override
    public void onConnectorEvent(ConnectorEvent event) {
    }

    @Override
    public String getLastTransactionId() {
        return this.lastTransactionId.get();
    }

    @Override
    public void reset() {
        super.reset();
        this.connected.set(false);
        this.lagBehindSource.set(null);
        this.numberOfCommittedTransactions.set(0L);
        this.sourceEventPosition.set(Collections.emptyMap());
        this.lastTransactionId.set(null);
    }
}

