/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.base.ChangeEventQueue;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.RetriableException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private final ChangeEventQueue<?> queue;
    private final AtomicReference<Throwable> producerThrowable;

    public ErrorHandler(Class<? extends SourceConnector> connectorType, String logicalName, ChangeEventQueue<?> queue) {
        this.queue = queue;
        this.producerThrowable = new AtomicReference();
    }

    public void setProducerThrowable(Throwable producerThrowable) {
        LOGGER.error("Producer failure", producerThrowable);
        boolean first = this.producerThrowable.compareAndSet(null, producerThrowable);
        boolean retriable = this.isRetriable(producerThrowable);
        if (first) {
            if (retriable) {
                this.queue.producerException(new RetriableException("An exception occurred in the change event producer. This connector will be restarted.", producerThrowable));
            } else {
                this.queue.producerException(new ConnectException("An exception occurred in the change event producer. This connector will be stopped.", producerThrowable));
            }
        }
    }

    public Throwable getProducerThrowable() {
        return this.producerThrowable.get();
    }

    protected boolean isRetriable(Throwable throwable) {
        return false;
    }
}

