/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.heartbeat;

import java.time.Duration;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.function.BlockingConsumer;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.heartbeat.DatabaseHeartbeatImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.heartbeat.HeartbeatErrorHandler;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.heartbeat.HeartbeatImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.jdbc.JdbcConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;

public interface Heartbeat {
    public static final String HEARTBEAT_INTERVAL_PROPERTY_NAME = "heartbeat.interval.ms";
    public static final Field HEARTBEAT_INTERVAL = Field.create("heartbeat.interval.ms").withDisplayName("Connector heartbeat interval (milli-seconds)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry(Field.Group.ADVANCED_HEARTBEAT, 0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Length of an interval in milli-seconds in in which the connector periodically sends heartbeat messages to a heartbeat topic. Use 0 to disable heartbeat messages. Disabled by default.").withDefault(0).withValidation(Field::isNonNegativeInteger);
    public static final Field HEARTBEAT_TOPICS_PREFIX = Field.create("heartbeat.topics.prefix").withDisplayName("A prefix used for naming of heartbeat topics").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry(Field.Group.ADVANCED_HEARTBEAT, 1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("The prefix that is used to name heartbeat topics.Defaults to __debezium-heartbeat.").withDefault("__debezium-heartbeat");
    public static final Heartbeat DEFAULT_NOOP_HEARTBEAT = new Heartbeat(){

        @Override
        public void heartbeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        }

        @Override
        public void forcedBeat(Map<String, ?> partition, Map<String, ?> offset, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        }

        @Override
        public void heartbeat(Map<String, ?> partition, OffsetProducer offsetProducer, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    };

    public void heartbeat(Map<String, ?> var1, Map<String, ?> var2, BlockingConsumer<SourceRecord> var3) throws InterruptedException;

    public void heartbeat(Map<String, ?> var1, OffsetProducer var2, BlockingConsumer<SourceRecord> var3) throws InterruptedException;

    public void forcedBeat(Map<String, ?> var1, Map<String, ?> var2, BlockingConsumer<SourceRecord> var3) throws InterruptedException;

    public boolean isEnabled();

    public static Heartbeat create(Duration heartbeatInterval, String topicName, String key) {
        return heartbeatInterval.isZero() ? DEFAULT_NOOP_HEARTBEAT : new HeartbeatImpl(heartbeatInterval, topicName, key);
    }

    public static Heartbeat create(Duration heartbeatInterval, String heartbeatQuery, String topicName, String key, JdbcConnection jdbcConnection, HeartbeatErrorHandler errorHandler) {
        if (heartbeatInterval.isZero()) {
            return DEFAULT_NOOP_HEARTBEAT;
        }
        if (heartbeatQuery != null) {
            return new DatabaseHeartbeatImpl(heartbeatInterval, topicName, key, jdbcConnection, heartbeatQuery, errorHandler);
        }
        return new HeartbeatImpl(heartbeatInterval, topicName, key);
    }

    @FunctionalInterface
    public static interface OffsetProducer {
        public Map<String, ?> offset();
    }
}

