/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.embedded.spi;

import java.time.Duration;
import java.util.Properties;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.embedded.EmbeddedEngine;

@Deprecated
@FunctionalInterface
public interface OffsetCommitPolicy
extends org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.engine.spi.OffsetCommitPolicy {
    public static OffsetCommitPolicy always() {
        return new AlwaysCommitOffsetPolicy();
    }

    public static OffsetCommitPolicy periodic(Configuration config) {
        return new PeriodicCommitOffsetPolicy(config);
    }

    default public OffsetCommitPolicy or(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) || other.performCommit(number, time);
    }

    default public OffsetCommitPolicy and(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) && other.performCommit(number, time);
    }

    public static class PeriodicCommitOffsetPolicy
    implements OffsetCommitPolicy {
        private final Duration minimumTime;

        public PeriodicCommitOffsetPolicy(Configuration config) {
            this.minimumTime = Duration.ofMillis(config.getLong(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS));
        }

        public PeriodicCommitOffsetPolicy(Properties properties) {
            this(Configuration.from(properties));
        }

        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return timeSinceLastCommit.compareTo(this.minimumTime) >= 0;
        }
    }

    public static class AlwaysCommitOffsetPolicy
    implements OffsetCommitPolicy {
        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return true;
        }
    }
}

