/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.Immutable;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Array;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Document;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Value;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;

@Immutable
final class ConvertingValue
implements Value {
    private final Value value;

    ConvertingValue(Value value) {
        assert (value != null);
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public int compareTo(Value that) {
        return this.value.compareTo(that);
    }

    @Override
    public Value.Type getType() {
        return this.value.getType();
    }

    @Override
    public Object asObject() {
        return this.value.asObject();
    }

    @Override
    public String asString() {
        return this.value.isNull() ? null : this.value.toString();
    }

    @Override
    public Boolean asBoolean() {
        if (this.value.isBoolean()) {
            return this.value.asBoolean();
        }
        if (this.value.isNumber()) {
            return this.value.asNumber().intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (this.value.isString()) {
            return Boolean.valueOf(this.asString());
        }
        return null;
    }

    @Override
    public Integer asInteger() {
        if (this.value.isInteger()) {
            return this.value.asInteger();
        }
        if (this.value.isNumber()) {
            return this.asNumber().intValue();
        }
        if (this.value.isString()) {
            try {
                return Integer.valueOf(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Long asLong() {
        if (this.value.isLong()) {
            return this.value.asLong();
        }
        if (this.value.isNumber()) {
            return this.asNumber().longValue();
        }
        if (this.value.isString()) {
            try {
                return Long.valueOf(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Float asFloat() {
        if (this.value.isFloat()) {
            return this.value.asFloat();
        }
        if (this.value.isNumber()) {
            return Float.valueOf(this.asNumber().floatValue());
        }
        if (this.value.isString()) {
            try {
                return Float.valueOf(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Double asDouble() {
        if (this.value.isDouble()) {
            return this.value.asDouble();
        }
        if (this.value.isNumber()) {
            return this.asNumber().doubleValue();
        }
        if (this.value.isString()) {
            try {
                return Double.valueOf(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Number asNumber() {
        if (this.value.isNumber()) {
            return this.value.asNumber();
        }
        if (this.value.isString()) {
            String str = this.value.asString();
            Number number = Strings.asNumber(str);
            if (number instanceof Short) {
                number = number.intValue();
            }
            return number;
        }
        return null;
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.value.isBigInteger()) {
            return this.value.asBigInteger();
        }
        if (this.value.isBigDecimal()) {
            return this.value.asBigDecimal().toBigInteger();
        }
        if (this.value instanceof Number) {
            return BigInteger.valueOf(this.asLong());
        }
        if (this.value.isString()) {
            try {
                return new BigInteger(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.value.isBigDecimal()) {
            return this.value.asBigDecimal();
        }
        if (this.value.isBigInteger()) {
            return new BigDecimal(this.value.asBigInteger());
        }
        if (this.value.isInteger() || this.value.isLong()) {
            return BigDecimal.valueOf(this.asLong());
        }
        if (this.value.isFloat() || this.value.isDouble()) {
            return BigDecimal.valueOf(this.asDouble());
        }
        if (this.value.isString()) {
            try {
                return new BigDecimal(this.asString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public byte[] asBytes() {
        if (this.value.isBinary()) {
            return this.value.asBytes();
        }
        if (this.value.isString()) {
            return this.value.asString().getBytes();
        }
        return null;
    }

    @Override
    public Document asDocument() {
        return this.value.isDocument() ? this.value.asDocument() : null;
    }

    @Override
    public Array asArray() {
        return this.value.isArray() ? this.value.asArray() : null;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public boolean isString() {
        return this.value.isString();
    }

    @Override
    public boolean isBoolean() {
        return this.value.isBoolean();
    }

    @Override
    public boolean isInteger() {
        return this.value.isInteger();
    }

    @Override
    public boolean isLong() {
        return this.value.isLong();
    }

    @Override
    public boolean isFloat() {
        return this.value.isFloat();
    }

    @Override
    public boolean isDouble() {
        return this.value.isDouble();
    }

    @Override
    public boolean isNumber() {
        return this.value.isNumber();
    }

    @Override
    public boolean isBigInteger() {
        return this.value.isBigInteger();
    }

    @Override
    public boolean isBigDecimal() {
        return this.value.isBigDecimal();
    }

    @Override
    public boolean isDocument() {
        return this.value.isDocument();
    }

    @Override
    public boolean isArray() {
        return this.value.isArray();
    }

    @Override
    public boolean isBinary() {
        return this.value.isBinary();
    }

    @Override
    public Value convert() {
        return this;
    }

    @Override
    public Value clone() {
        Value clonedValue = this.value.clone();
        if (clonedValue == this.value) {
            return this;
        }
        return new ConvertingValue(clonedValue);
    }
}

