/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.annotation.NotThreadSafe;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Array;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.BasicEntry;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Value;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Iterators;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.MathOps;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Sequences;

@NotThreadSafe
final class BasicArray
implements Array {
    private static final BiFunction<Integer, Value, Array.Entry> CONVERT_PAIR_TO_ENTRY = new BiFunction<Integer, Value, Array.Entry>(){

        @Override
        public Array.Entry apply(Integer index, Value value) {
            return new BasicEntry(index, value);
        }
    };
    private final List<Value> values;

    BasicArray() {
        this.values = new ArrayList<Value>();
    }

    BasicArray(List<Value> values) {
        assert (values != null);
        this.values = values;
    }

    BasicArray(Value[] values) {
        if (values == null || values.length == 0) {
            this.values = new ArrayList<Value>();
        } else {
            this.values = new ArrayList<Value>(values.length);
            for (Value value : values) {
                this.values.add(value != null ? value : Value.nullValue());
            }
        }
    }

    protected final int indexFrom(CharSequence name) {
        return Integer.parseInt(name.toString());
    }

    protected final boolean isValidIndex(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int compareTo(Array that) {
        if (that == null) {
            return 1;
        }
        int size = this.size();
        if (size != that.size()) {
            return size - that.size();
        }
        Array thatArray = that;
        for (int i = 0; i != size; ++i) {
            Value thisValue;
            Value thatValue = thatArray.get(i);
            int diff = thatValue.compareTo(thisValue = this.get(i));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    public Iterator<Array.Entry> iterator() {
        return Iterators.around(Sequences.infiniteIntegers(0), this.values, CONVERT_PAIR_TO_ENTRY);
    }

    @Override
    public Value remove(int index) {
        if (this.isValidIndex(index)) {
            return this.values.remove(index);
        }
        return null;
    }

    @Override
    public Array removeAll() {
        this.values.clear();
        return this;
    }

    @Override
    public boolean has(int index) {
        return this.isValidIndex(index);
    }

    @Override
    public Value get(int index) {
        return this.isValidIndex(index) ? this.values.get(index) : null;
    }

    @Override
    public Array setValue(int index, Value value) {
        if (value == null) {
            value = Value.nullValue();
        }
        if (this.isValidIndex(index)) {
            this.values.set(index, value);
        } else if (this.isValidIndex(index - 1)) {
            this.values.add(value);
        } else {
            throw new IllegalArgumentException("The index " + index + " is too large for this array, which has only " + this.size() + " values");
        }
        return this;
    }

    @Override
    public Array expand(int desiredSize, Value value) {
        if (desiredSize <= this.values.size()) {
            return this;
        }
        if (value == null) {
            value = Value.nullValue();
        }
        for (int i = this.values.size(); i < desiredSize; ++i) {
            this.values.add(value);
        }
        return this;
    }

    @Override
    public Array increment(int index, Value increment) {
        if (!increment.isNumber()) {
            throw new IllegalArgumentException("The increment must be a number but is " + increment);
        }
        Value current = this.get(index);
        if (current.isNumber()) {
            Value updated = Value.create(MathOps.add(current.asNumber(), increment.asNumber()));
            this.setValue(index, Value.create(updated));
        }
        return this;
    }

    @Override
    public Array add(Value value) {
        if (value == null) {
            value = Value.nullValue();
        }
        this.values.add(value);
        return this;
    }

    @Override
    public Iterable<Value> values() {
        return this.values;
    }

    @Override
    public Array clone() {
        return new BasicArray().addAll(this.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicArray) {
            BasicArray that = (BasicArray)obj;
            return this.values.equals(that.values);
        }
        return false;
    }

    public String toString() {
        return this.values.toString();
    }
}

