/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.BasicArray;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Document;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Value;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Iterators;

public interface Array
extends Iterable<Entry>,
Comparable<Array> {
    public static Array create() {
        return new BasicArray();
    }

    public static Array createWithNulls(int number) {
        Object[] vals = new Value[number];
        Arrays.fill(vals, Value.nullValue());
        return new BasicArray((Value[])vals);
    }

    public static Array create(Object ... values) {
        if (values == null || values.length == 0) {
            return Array.create();
        }
        Value[] vals = new Value[values.length];
        for (int i = 0; i != values.length; ++i) {
            vals[i] = Value.create(values[i]);
        }
        return new BasicArray(vals);
    }

    public static Array create(Value[] values) {
        if (values == null || values.length == 0) {
            return Array.create();
        }
        return new BasicArray(values);
    }

    public static Array create(Value firstValue, Value secondValue, Value ... additionalValues) {
        Value[] values = new Value[additionalValues.length + 2];
        values[0] = Value.create(firstValue);
        values[1] = Value.create(secondValue);
        for (int i = 0; i != additionalValues.length; ++i) {
            values[i + 2] = Value.create(additionalValues[i]);
        }
        return new BasicArray(values);
    }

    public static Array create(Iterable<?> values) {
        if (values == null) {
            return Array.create();
        }
        BasicArray array = new BasicArray();
        values.forEach(obj -> array.add(Value.create(obj)));
        return array;
    }

    public static Array create(List<Value> values) {
        return values == null || values.isEmpty() ? Array.create() : new BasicArray(values);
    }

    public int size();

    public boolean isEmpty();

    public boolean has(int var1);

    public Value get(int var1);

    default public Value get(int index, Object defaultValue) {
        Value value = this.get(index);
        return value != null ? value : Value.create(defaultValue);
    }

    default public boolean isNull(int index) {
        Value value = this.get(index);
        return value != null ? value.isNull() : false;
    }

    default public boolean isNullOrMissing(int index) {
        Value value = this.get(index);
        return value != null ? value.isNull() : true;
    }

    public Value remove(int var1);

    public Array removeAll();

    default public Array addAll(Object ... values) {
        if (values != null) {
            for (Object obj : values) {
                this.add(Value.create(obj));
            }
        }
        return this;
    }

    default public Array addAll(Value ... values) {
        if (values != null) {
            this.addAll(Stream.of(values));
        }
        return this;
    }

    default public Array addAll(Iterable<Value> values) {
        if (values != null) {
            values.forEach(value -> this.add(value != null ? value.clone() : Value.nullValue()));
        }
        return this;
    }

    default public Array addAll(Stream<Value> values) {
        if (values != null) {
            values.forEach(value -> this.add(value != null ? value.clone() : Value.nullValue()));
        }
        return this;
    }

    public Array add(Value var1);

    default public Array addNull() {
        this.add(Value.nullValue());
        return this;
    }

    default public Array add(String value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(boolean value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Boolean value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(int value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(long value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(float value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(double value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(BigInteger value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(BigDecimal value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Integer value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Long value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Float value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Double value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Document value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array add(Array value) {
        this.add(Value.create(value));
        return this;
    }

    default public Array putAll(Iterable<Entry> entries) {
        if (entries != null) {
            entries.forEach(entry -> {
                if (entry != null) {
                    Value value = entry.getValue().clone();
                    this.setValue(entry.getIndex(), value);
                }
            });
        }
        return this;
    }

    default public Iterable<Value> values() {
        return Iterators.around(Iterators.around(this, entry -> entry.getValue()));
    }

    default public Stream<Entry> streamEntries() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<Value> streamValues() {
        return StreamSupport.stream(this.values().spliterator(), false);
    }

    default public Array transform(BiFunction<Integer, Value, Value> transformer) {
        for (int i = 0; i != this.size(); ++i) {
            Value existing = this.get(i);
            Value updated = transformer.apply(i, existing);
            if (updated == null) {
                updated = Value.nullValue();
            }
            if (updated == existing) continue;
            this.setValue(i, updated);
        }
        return this;
    }

    default public Array setNull(int index) {
        return this.setValue(index, Value.nullValue());
    }

    default public Array setBoolean(int index, boolean value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, int value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, long value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, float value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, double value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, BigInteger value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setNumber(int index, BigDecimal value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setString(int index, String value) {
        return this.setValue(index, Value.create(value));
    }

    default public Array setBinary(int index, byte[] data) {
        return this.setValue(index, Value.create(data));
    }

    public Array setValue(int var1, Value var2);

    default public Array expand(int desiredSize) {
        return this.expand(desiredSize, Value.nullValue());
    }

    public Array expand(int var1, Value var2);

    default public Array expand(int desiredSize, boolean value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array expand(int desiredSize, int value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array expand(int desiredSize, long value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array expand(int desiredSize, float value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array expand(int desiredSize, double value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array expand(int desiredSize, String value) {
        return this.expand(desiredSize, Value.create(value));
    }

    default public Array increment(int index, int increment) {
        return this.increment(index, Value.create(increment));
    }

    default public Array increment(int index, long increment) {
        return this.increment(index, Value.create(increment));
    }

    default public Array increment(int index, double increment) {
        return this.increment(index, Value.create(increment));
    }

    default public Array increment(int index, float increment) {
        return this.increment(index, Value.create(increment));
    }

    public Array increment(int var1, Value var2);

    default public Document setDocument(int index) {
        return this.setDocument(index, Document.create());
    }

    default public Document setDocument(int index, Document document) {
        if (document == null) {
            document = Document.create();
        }
        this.setValue(index, Value.create(document));
        return document;
    }

    default public Array setArray(int index) {
        return this.setArray(index, Array.create());
    }

    default public Array setArray(int index, Array array) {
        if (array == null) {
            array = Array.create();
        }
        this.setValue(index, Value.create(array));
        return array;
    }

    default public Array setArray(int index, Value ... values) {
        Array array = Array.create(values);
        this.setValue(index, Value.create(array));
        return array;
    }

    public Array clone();

    public static interface Entry
    extends Comparable<Entry> {
        public int getIndex();

        public Value getValue();

        @Override
        default public int compareTo(Entry that) {
            if (that == null) {
                return 1;
            }
            int diff = this.getIndex() - that.getIndex();
            if (diff != 0) {
                return diff;
            }
            return this.getValue().compareTo(that.getValue());
        }
    }
}

