/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.SpecialValueDecimal;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;

public class VariableScaleDecimal {
    public static final String LOGICAL_NAME = "org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.VariableScaleDecimal";
    public static final String VALUE_FIELD = "value";
    public static final String SCALE_FIELD = "scale";
    public static final Struct ZERO = VariableScaleDecimal.fromLogical(VariableScaleDecimal.schema(), SpecialValueDecimal.ZERO);

    public static SchemaBuilder builder() {
        return SchemaBuilder.struct().name(LOGICAL_NAME).version(1).doc("Variable scaled decimal").field(SCALE_FIELD, Schema.INT32_SCHEMA).field(VALUE_FIELD, Schema.BYTES_SCHEMA);
    }

    public static Schema schema() {
        return VariableScaleDecimal.builder().build();
    }

    public static Schema optionalSchema() {
        return VariableScaleDecimal.builder().optional().build();
    }

    public static Struct fromLogical(Schema schema, SpecialValueDecimal value) {
        return VariableScaleDecimal.fromLogical(schema, value.getDecimalValue().orElse(null));
    }

    public static Struct fromLogical(Schema schema, BigDecimal decimalValue) {
        Objects.requireNonNull(decimalValue, "decimalValue may not be null");
        Struct result = new Struct(schema);
        result.put(VALUE_FIELD, (Object)decimalValue.unscaledValue().toByteArray());
        result.put(SCALE_FIELD, (Object)decimalValue.scale());
        return result;
    }

    public static SpecialValueDecimal toLogical(Struct value) {
        return new SpecialValueDecimal(new BigDecimal(new BigInteger(value.getBytes(VALUE_FIELD)), value.getInt32(SCALE_FIELD)));
    }
}

