/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.converters;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Instantiator;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.errors.DataException;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.Converter;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.ConverterConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferConverter
implements Converter,
HeaderConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteBufferConverter.class);
    public static final String DELEGATE_CONVERTER_TYPE = "delegate.converter.type";
    private Converter delegateConverter;
    private static final ConfigDef CONFIG_DEF = ConverterConfig.newConfigDef();

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        String converterTypeName = (String)configs.get(DELEGATE_CONVERTER_TYPE);
        if (converterTypeName != null) {
            this.delegateConverter = (Converter)Instantiator.getInstance(converterTypeName, () -> this.getClass().getClassLoader(), null);
            this.delegateConverter.configure(Configuration.from(configs).subset(DELEGATE_CONVERTER_TYPE, true).asMap(), isKey);
        }
    }

    @Override
    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (schema != null && schema.type() != Schema.Type.BYTES) {
            this.assertDataException("schema", (Object)schema.type());
            LOGGER.debug("Value is not of Schema.Type.BYTES, delegating to " + this.delegateConverter.getClass().getName());
            return this.delegateConverter.fromConnectData(topic, schema, value);
        }
        if (value != null && !(value instanceof ByteBuffer)) {
            this.assertDataException("value", value.getClass().getName());
            LOGGER.debug("Value is not of type ByteBuffer, delegating to " + this.delegateConverter.getClass().getName());
            return this.delegateConverter.fromConnectData(topic, schema, value);
        }
        return value == null ? null : ((ByteBuffer)value).array();
    }

    private void assertDataException(String name, Object type) {
        if (this.delegateConverter == null) {
            throw new DataException("A " + name + " of type '" + type + "' requires a delegate.converter.type to be configured");
        }
    }

    @Override
    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return new SchemaAndValue(Schema.OPTIONAL_BYTES_SCHEMA, value == null ? null : ByteBuffer.wrap(value));
    }

    @Override
    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    @Override
    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    @Override
    public void close() {
    }

    static {
        CONFIG_DEF.define(DELEGATE_CONVERTER_TYPE, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "Specifies the delegate converter class");
    }
}

