/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream;

import java.util.Map;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.BaseChangeRecordEmitter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.Envelope;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.Partition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;

public class XStreamChangeRecordEmitter
extends BaseChangeRecordEmitter<ColumnValue> {
    private final RowLCR lcr;
    private final Map<String, Object> chunkValues;

    public XStreamChangeRecordEmitter(Partition partition, OffsetContext offset, RowLCR lcr, Map<String, Object> chunkValues, Table table, Clock clock) {
        super(partition, offset, table, clock);
        this.lcr = lcr;
        this.chunkValues = chunkValues;
    }

    @Override
    protected Envelope.Operation getOperation() {
        switch (this.lcr.getCommandType()) {
            case "INSERT": {
                return Envelope.Operation.CREATE;
            }
            case "DELETE": {
                return Envelope.Operation.DELETE;
            }
            case "UPDATE": {
                return Envelope.Operation.UPDATE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.lcr);
    }

    @Override
    protected Object[] getOldColumnValues() {
        return this.getColumnValues(this.lcr.getOldValues());
    }

    @Override
    protected Object[] getNewColumnValues() {
        return this.getColumnValues(this.lcr.getNewValues());
    }

    private Object[] getColumnValues(ColumnValue[] columnValues) {
        Object[] values = new Object[this.table.columns().size()];
        for (ColumnValue columnValue : columnValues) {
            int index = this.table.columnWithName(columnValue.getColumnName()).position() - 1;
            values[index] = columnValue.getColumnData();
        }
        for (Map.Entry entry : this.chunkValues.entrySet()) {
            int index = this.table.columnWithName((String)entry.getKey()).position() - 1;
            values[index] = entry.getValue();
        }
        return values;
    }
}

