/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream;

import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.AbstractStreamingAdapter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleOffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OraclePartition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleTaskContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Scn;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.StreamingAdapter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream.LcrPosition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream.XStreamOracleOffsetContextLoader;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream.XstreamStreamingChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.document.Document;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.ErrorHandler;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.OffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.history.HistoryRecordComparator;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;

public class XStreamAdapter
extends AbstractStreamingAdapter {
    private static final String TYPE = "xstream";

    public XStreamAdapter(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            @Override
            public boolean isPositionAtOrBefore(Document recorded, Document desired) {
                Scn desiredScn;
                LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString("lcr_position"));
                LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString("lcr_position"));
                Scn recordedScn = recordedPosition != null ? recordedPosition.getScn() : XStreamAdapter.this.resolveScn(recorded);
                Scn scn = desiredScn = desiredPosition != null ? desiredPosition.getScn() : XStreamAdapter.this.resolveScn(desired);
                if (recordedPosition != null && desiredPosition != null) {
                    return recordedPosition.compareTo(desiredPosition) < 1;
                }
                return recordedScn.compareTo(desiredScn) < 1;
            }
        };
    }

    @Override
    public OffsetContext.Loader<OracleOffsetContext> getOffsetContextLoader() {
        return new XStreamOracleOffsetContextLoader(this.connectorConfig);
    }

    @Override
    public StreamingChangeEventSource<OraclePartition, OracleOffsetContext> getSource(OracleConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        return new XstreamStreamingChangeEventSource(this.connectorConfig, connection, dispatcher, errorHandler, clock, schema, streamingMetrics);
    }

    @Override
    public StreamingAdapter.TableNameCaseSensitivity getTableNameCaseSensitivity(OracleConnection connection) {
        if (connection.getOracleVersion().getMajor() == 11) {
            return StreamingAdapter.TableNameCaseSensitivity.SENSITIVE;
        }
        return super.getTableNameCaseSensitivity(connection);
    }
}

