/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.xstream;

import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.streams.ChunkColumnValue;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;

public class ChunkColumnValues {
    private final List<ChunkColumnValue> values = new ArrayList<ChunkColumnValue>();
    private long size = 0L;

    public int getChunkType() {
        if (this.values.isEmpty()) {
            throw new DebeziumException("Unable to resolve chunk type since no chunks have yet been added.");
        }
        return this.values.get(0).getChunkType();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public void add(ChunkColumnValue chunkColumnValue) {
        this.size += (long)this.calculateChunkSize(chunkColumnValue);
        this.values.add(chunkColumnValue);
    }

    public String getStringValue() throws SQLException {
        if (this.size == 0L) {
            return null;
        }
        StringBuilder data = new StringBuilder();
        for (ChunkColumnValue value : this.values) {
            data.append(value.getColumnData().stringValue());
        }
        return data.toString();
    }

    public byte[] getByteArray() throws SQLException {
        if (this.size == 0L) {
            ChunkColumnValue firstChunk;
            if (!this.values.isEmpty() && (firstChunk = this.values.get(0)).isEmptyChunk()) {
                return ByteBuffer.allocate(0).array();
            }
            return null;
        }
        if (this.size > Integer.MAX_VALUE) {
            throw new DebeziumException("Size " + this.size + " exceeds maximum value " + Integer.MAX_VALUE);
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)this.size);
        for (ChunkColumnValue columnValue : this.values) {
            buffer.put(columnValue.getColumnData().getBytes());
        }
        return buffer.array();
    }

    private int calculateChunkSize(ChunkColumnValue chunkColumnValue) {
        try {
            switch (chunkColumnValue.getChunkType()) {
                case 1: 
                case 3: {
                    return chunkColumnValue.getColumnData().stringValue().length();
                }
                case 2: {
                    return chunkColumnValue.getColumnData().getBytes().length;
                }
            }
            return 0;
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to calculate the size of the chunk column data value");
        }
    }
}

