/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor.infinispan.marshalling;

import java.time.Instant;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Scn;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.DmlEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.EventType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@ProtoAdapter(value=LogMinerEvent.class)
public class LogMinerEventAdapter {
    @ProtoFactory
    public LogMinerEvent factory(int eventType, String scn, String tableId, String rowId, String rsId, String changeTime, LogMinerDmlEntryImpl entry, String columnName, Boolean binary, String data) {
        EventType type = EventType.from(eventType);
        Scn eventScn = Scn.valueOf(scn);
        TableId id = Strings.isNullOrEmpty(tableId) ? null : TableId.parse(tableId);
        Instant time = Strings.isNullOrEmpty(changeTime) ? null : Instant.parse(changeTime);
        switch (type) {
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return new DmlEvent(type, eventScn, id, rowId, rsId, time, entry);
            }
            case SELECT_LOB_LOCATOR: {
                return new SelectLobLocatorEvent(type, eventScn, id, rowId, rsId, time, entry, columnName, binary);
            }
            case LOB_WRITE: {
                return new LobWriteEvent(type, eventScn, id, rowId, rsId, time, data);
            }
            case LOB_ERASE: {
                return new LobEraseEvent(type, eventScn, id, rowId, rsId, time);
            }
            case LOB_TRIM: {
                return new LogMinerEvent(type, eventScn, id, rowId, rsId, time);
            }
        }
        throw new DebeziumException("Unknown event type: " + eventType);
    }

    @ProtoField(number=1, required=true)
    public int getEventType(LogMinerEvent event) {
        return event.getEventType().getValue();
    }

    @ProtoField(number=2, required=true)
    public String getScn(LogMinerEvent event) {
        return event.getScn().toString();
    }

    @ProtoField(number=3, required=true)
    public String getTableId(LogMinerEvent event) {
        return event.getTableId().identifier();
    }

    @ProtoField(number=4, required=true)
    public String getRowId(LogMinerEvent event) {
        return event.getRowId();
    }

    @ProtoField(number=5, required=true)
    public String getRsId(LogMinerEvent event) {
        return event.getRsId();
    }

    @ProtoField(number=6, required=true)
    public String getChangeTime(LogMinerEvent event) {
        return event.getChangeTime().toString();
    }

    @ProtoField(number=7)
    public LogMinerDmlEntryImpl getEntry(LogMinerEvent event) {
        switch (event.getEventType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case SELECT_LOB_LOCATOR: {
                return (LogMinerDmlEntryImpl)((DmlEvent)event).getDmlEntry();
            }
        }
        return null;
    }

    @ProtoField(number=8)
    public String getColumnName(LogMinerEvent event) {
        if (EventType.SELECT_LOB_LOCATOR.equals((Object)event.getEventType())) {
            return ((SelectLobLocatorEvent)event).getColumnName();
        }
        return null;
    }

    @ProtoField(number=9)
    public Boolean getBinary(LogMinerEvent event) {
        if (EventType.SELECT_LOB_LOCATOR.equals((Object)event.getEventType())) {
            return ((SelectLobLocatorEvent)event).isBinary();
        }
        return null;
    }

    @ProtoField(number=10)
    public String getData(LogMinerEvent event) {
        if (EventType.LOB_WRITE.equals((Object)event.getEventType())) {
            return ((LobWriteEvent)event).getData();
        }
        return null;
    }
}

