/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.BlobChunkList;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.LogMinerHelper;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.DmlEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.EventType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.Transaction;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionReconciliation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionReconciliation.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;

    public TransactionReconciliation(OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema) {
        this.connectorConfig = connectorConfig;
        this.schema = schema;
    }

    public void reconcile(Transaction transaction) {
        if (!this.connectorConfig.isLobEnabled()) {
            return;
        }
        String transactionId = transaction.getTransactionId();
        LOGGER.trace("Reconciling transaction {}", (Object)transactionId);
        DmlEvent prevEvent = null;
        int prevEventSize = transaction.getEvents().size();
        int i = 0;
        block4: while (i < transaction.getEvents().size()) {
            LogMinerEvent event = transaction.getEvents().get(i);
            LOGGER.trace("Processing event {}", (Object)event);
            switch (event.getEventType()) {
                case SELECT_LOB_LOCATOR: {
                    if (!this.shouldMergeSelectLobLocatorEvent(transaction, i, (SelectLobLocatorEvent)event, prevEvent)) break;
                    continue block4;
                }
                case INSERT: 
                case UPDATE: {
                    if (!this.shouldMergeDmlEvent(transaction, i, (DmlEvent)event, prevEvent)) break;
                    continue block4;
                }
            }
            ++i;
            prevEvent = (DmlEvent)event;
            LOGGER.trace("Previous event is now {}", (Object)prevEvent);
        }
        int eventSize = transaction.getEvents().size();
        if (eventSize != prevEventSize) {
            LOGGER.trace("Reconciled transaction {} from {} events to {}.", new Object[]{transactionId, prevEventSize, eventSize});
        } else {
            LOGGER.trace("Transaction {} event queue was unmodified.", (Object)transactionId);
        }
    }

    protected boolean shouldMergeSelectLobLocatorEvent(Transaction transaction, int index, SelectLobLocatorEvent event, DmlEvent prevEvent) {
        int lobEraseEvents;
        LOGGER.trace("\tDetected SelectLobLocatorEvent for column '{}'", (Object)event.getColumnName());
        int columnIndex = LogMinerHelper.getColumnIndexByName(event.getColumnName(), this.schema.tableFor(event.getTableId()));
        Object lobData = null;
        List<String> lobWrites = this.readAndCombineLobWriteEvents(transaction, index, event.isBinary());
        if (!lobWrites.isEmpty()) {
            lobData = event.isBinary() ? new BlobChunkList(lobWrites) : String.join((CharSequence)"", lobWrites);
        }
        if ((lobEraseEvents = this.readAndConsumeLobEraseEvents(transaction, index)) > 0) {
            LOGGER.warn("LOB_ERASE for table '{}' column '{}' is not supported, use DML operations to manipulate LOB columns only.", (Object)event.getTableId(), (Object)event.getColumnName());
            if (lobWrites.isEmpty()) {
                transaction.getEvents().remove(index);
                return true;
            }
        } else if (lobEraseEvents == 0 && lobWrites.isEmpty()) {
            transaction.getEvents().remove(index);
            return true;
        }
        if (prevEvent == null) {
            LOGGER.trace("\tAdding column '{}' to current event", (Object)event.getColumnName());
            event.getDmlEntry().getNewValues()[columnIndex] = lobData;
            return false;
        }
        if (EventType.INSERT == prevEvent.getEventType()) {
            if (this.isForSameTableOrScn(event, prevEvent)) {
                LOGGER.trace("\tMerging SEL_LOB_LOCATOR with previous INSERT event");
                Object prevValue = prevEvent.getDmlEntry().getNewValues()[columnIndex];
                if (!"EMPTY_CLOB()".equals(prevValue) && !"EMPTY_BLOB()".equals(prevValue)) {
                    throw new DebeziumException("Expected to find column '" + event.getColumnName() + "' in table '" + prevEvent.getTableId() + "' to be initialized as an empty LOB value.'");
                }
                prevEvent.getDmlEntry().getNewValues()[columnIndex] = lobData;
                transaction.getEvents().remove(index);
                return true;
            }
        } else if (EventType.UPDATE == prevEvent.getEventType()) {
            if (this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tUpdating SEL_LOB_LOCATOR column '{}' to previous UPDATE event", (Object)event.getColumnName());
                prevEvent.getDmlEntry().getNewValues()[columnIndex] = lobData;
                transaction.getEvents().remove(index);
                return true;
            }
        } else if (EventType.SELECT_LOB_LOCATOR == prevEvent.getEventType()) {
            if (this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tAdding column '{}' to previous SEL_LOB_LOCATOR event", (Object)event.getColumnName());
                prevEvent.getDmlEntry().getNewValues()[columnIndex] = lobData;
                transaction.getEvents().remove(index);
                return true;
            }
        } else {
            throw new DebeziumException("Unexpected previous event operation: " + (Object)((Object)prevEvent.getEventType()));
        }
        LOGGER.trace("\tSEL_LOB_LOCATOR event is for different row, merge skipped.");
        LOGGER.trace("\tAdding column '{}' to current event", (Object)event.getColumnName());
        event.getDmlEntry().getNewValues()[columnIndex] = lobData;
        return false;
    }

    protected boolean shouldMergeDmlEvent(Transaction transaction, int index, DmlEvent event, DmlEvent prevEvent) {
        LOGGER.trace("\tDetected DmlEvent {}", (Object)event.getEventType());
        if (prevEvent == null) {
            return false;
        }
        if (EventType.INSERT == prevEvent.getEventType()) {
            if (EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tMerging UPDATE event with previous INSERT event");
                this.mergeNewColumns(event, prevEvent);
                transaction.getEvents().remove(index);
                return true;
            }
        } else if (EventType.UPDATE == prevEvent.getEventType()) {
            if (EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
                LOGGER.trace("\tMerging UPDATE event with previous UPDATE event");
                this.mergeNewColumns(event, prevEvent);
                transaction.getEvents().remove(index);
                return true;
            }
        } else if (EventType.SELECT_LOB_LOCATOR == prevEvent.getEventType() && EventType.UPDATE == event.getEventType() && this.isForSameTableOrScn(event, prevEvent) && this.isSameTableRow(event, prevEvent)) {
            LOGGER.trace("\tMerging UPDATE event with previous SEL_LOB_LOCATOR event");
            for (int i = 0; i < event.getDmlEntry().getNewValues().length; ++i) {
                Object value = event.getDmlEntry().getNewValues()[i];
                Object prevValue = prevEvent.getDmlEntry().getNewValues()[i];
                if (prevValue != null || value == null) continue;
                LOGGER.trace("\tAdding column index {} to previous SEL_LOB_LOCATOR event", (Object)i);
                prevEvent.getDmlEntry().getNewValues()[i] = value;
            }
            transaction.getEvents().remove(index);
            return true;
        }
        LOGGER.trace("\tDmlEvent {} event is for different row, merge skipped.", (Object)event.getEventType());
        return false;
    }

    protected List<String> readAndCombineLobWriteEvents(Transaction transaction, int index, boolean binaryData) {
        LogMinerEvent event;
        int i;
        ArrayList<String> chunks = new ArrayList<String>();
        for (i = index + 1; i < transaction.getEvents().size() && (event = transaction.getEvents().get(i)) instanceof LobWriteEvent; ++i) {
            LobWriteEvent writeEvent = (LobWriteEvent)event;
            if (binaryData && !writeEvent.getData().startsWith("HEXTORAW('") && !writeEvent.getData().endsWith("')")) {
                throw new DebeziumException("Unexpected BLOB data chunk: " + writeEvent.getData());
            }
            chunks.add(writeEvent.getData());
        }
        if (!chunks.isEmpty()) {
            LOGGER.trace("\tCombined {} LobWriteEvent events", (Object)chunks.size());
            for (i = 0; i < chunks.size(); ++i) {
                transaction.getEvents().remove(index + 1);
            }
        }
        return chunks;
    }

    protected int readAndConsumeLobEraseEvents(Transaction transaction, int index) {
        LogMinerEvent event;
        int i;
        int events = 0;
        for (i = index + 1; i < transaction.getEvents().size() && (event = transaction.getEvents().get(i)) instanceof LobEraseEvent; ++i) {
            ++events;
        }
        if (events > 0) {
            LOGGER.trace("\tConsumed {} LobErase events", (Object)events);
            for (i = 0; i < events; ++i) {
                transaction.getEvents().remove(index + 1);
            }
        }
        return events;
    }

    protected boolean isForSameTableOrScn(LogMinerEvent event, LogMinerEvent prevEvent) {
        if (prevEvent != null) {
            if (event.getTableId().equals(prevEvent.getTableId())) {
                return true;
            }
            return event.getScn().equals(prevEvent.getScn()) && event.getRsId().equals(prevEvent.getRsId());
        }
        return false;
    }

    protected boolean isSameTableRow(DmlEvent event, DmlEvent prevEvent) {
        Table table = this.schema.tableFor(event.getTableId());
        if (table == null) {
            LOGGER.trace("Unable to locate table '{}' schema, unable to detect if same row.", (Object)event.getTableId());
            return false;
        }
        for (String columnName : table.primaryKeyColumnNames()) {
            int position = LogMinerHelper.getColumnIndexByName(columnName, table);
            Object prevValue = prevEvent.getDmlEntry().getNewValues()[position];
            if (prevValue == null) {
                throw new DebeziumException("Could not find column " + columnName + " in previous event");
            }
            Object value = event.getDmlEntry().getNewValues()[position];
            if (value == null) {
                throw new DebeziumException("Could not find column " + columnName + " in event");
            }
            if (Objects.equals(value, prevValue)) continue;
            return false;
        }
        return true;
    }

    protected void mergeNewColumns(DmlEvent event, DmlEvent prevEvent) {
        boolean prevEventIsInsert = EventType.INSERT == prevEvent.getEventType();
        for (int i = 0; i < event.getDmlEntry().getNewValues().length; ++i) {
            Object value = event.getDmlEntry().getNewValues()[i];
            Object prevValue = prevEvent.getDmlEntry().getNewValues()[i];
            if (prevEventIsInsert && "EMPTY_CLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated CLOB value.", (Object)i);
                prevEvent.getDmlEntry().getNewValues()[i] = value;
                continue;
            }
            if (prevEventIsInsert && "EMPTY_BLOB()".equals(prevValue)) {
                LOGGER.trace("\tAssigning column index {} with updated BLOB value.", (Object)i);
                prevEvent.getDmlEntry().getNewValues()[i] = value;
                continue;
            }
            if (prevEventIsInsert || value == null) continue;
            LOGGER.trace("\tUpdating column index {} in previous event", (Object)i);
            prevEvent.getDmlEntry().getNewValues()[i] = value;
        }
    }
}

