/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleOffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OraclePartition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Scn;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.DmlEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.EventType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.Transaction;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.DmlParserException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor.TransactionCache;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.processor.TransactionReconciliation;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.ChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogMinerEventProcessor
implements LogMinerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogMinerEventProcessor.class);
    private final ChangeEventSource.ChangeEventSourceContext context;
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final EventDispatcher<TableId> dispatcher;
    private final OracleStreamingChangeEventSourceMetrics metrics;
    private final TransactionReconciliation reconciliation;
    private final LogMinerDmlParser dmlParser;
    private final SelectLobParser selectLobParser;
    protected final Counters counters;
    private Scn lastProcessedScn = Scn.NULL;

    public AbstractLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema, OraclePartition partition, OracleOffsetContext offsetContext, EventDispatcher<TableId> dispatcher, OracleStreamingChangeEventSourceMetrics metrics) {
        this.context = context;
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.reconciliation = new TransactionReconciliation(connectorConfig, schema);
        this.counters = new Counters();
        this.dmlParser = new LogMinerDmlParser();
        this.selectLobParser = new SelectLobParser();
    }

    protected OracleConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected OracleDatabaseSchema getSchema() {
        return this.schema;
    }

    protected TransactionReconciliation getReconciliation() {
        return this.reconciliation;
    }

    protected boolean isRecentlyCommitted(String transactionId) {
        return false;
    }

    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return false;
    }

    protected boolean isTransactionIdAllowed(String transactionId) {
        return true;
    }

    protected Scn getLastProcessedScn() {
        return this.lastProcessedScn;
    }

    protected abstract TransactionCache<?> getTransactionCache();

    protected boolean isTrxIdRawValue() {
        return true;
    }

    protected void processResults(ResultSet resultSet) throws SQLException, InterruptedException {
        while (this.context.isRunning() && this.hasNextWithMetricsUpdate(resultSet)) {
            ++this.counters.rows;
            this.processRow(LogMinerEventRow.fromResultSet(resultSet, this.getConfig().getCatalogName(), this.isTrxIdRawValue()));
        }
    }

    protected void processRow(LogMinerEventRow row) throws SQLException, InterruptedException {
        if (!row.getEventType().equals((Object)EventType.MISSING_SCN)) {
            this.lastProcessedScn = row.getScn();
        }
        switch (row.getEventType()) {
            case MISSING_SCN: {
                this.handleMissingScn(row);
            }
            case START: {
                this.handleStart(row);
                break;
            }
            case COMMIT: {
                this.handleCommit(row);
                break;
            }
            case ROLLBACK: {
                this.handleRollback(row);
                break;
            }
            case DDL: {
                this.handleSchemaChange(row);
                break;
            }
            case SELECT_LOB_LOCATOR: {
                this.handleSelectLobLocator(row);
                break;
            }
            case LOB_WRITE: {
                this.handleLobWrite(row);
                break;
            }
            case LOB_ERASE: {
                this.handleLobErase(row);
                break;
            }
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                this.handleDataEvent(row);
            }
        }
    }

    protected void handleMissingScn(LogMinerEventRow row) {
        LOGGER.warn("Missing SCN detected. {}", (Object)row);
    }

    protected void handleStart(LogMinerEventRow row) {
        String transactionId = row.getTransactionId();
        Transaction transaction = this.getTransactionCache().get(transactionId);
        if (transaction == null && !this.isRecentlyCommitted(transactionId)) {
            this.getTransactionCache().put(transactionId, new Transaction(transactionId, row.getScn(), row.getChangeTime()));
            this.metrics.setActiveTransactions(this.getTransactionCache().size());
        }
    }

    protected abstract void handleCommit(LogMinerEventRow var1) throws InterruptedException;

    protected void handleRollback(LogMinerEventRow row) {
    }

    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        if (this.hasSchemaChangeBeenSeen(row)) {
            LOGGER.trace("DDL: Scn {}, SQL '{}' has already been processed, skipped.", (Object)row.getScn(), (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("DDL: '{}' {}", (Object)row.getRedoSql(), (Object)row);
        if (row.getTableName() != null) {
            ++this.counters.ddlCount;
            TableId tableId = row.getTableId();
            this.dispatcher.dispatchSchemaChangeEvent(tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.getConfig(), this.partition, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), row.getRedoSql(), this.getSchema(), row.getChangeTime(), this.metrics));
        }
    }

    protected void handleSelectLobLocator(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, SEL_LOB_LOCATOR '{}' skipped.", (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("SEL_LOB_LOCATOR: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("SEL_LOB_LOCATOR for table '{}' is not known, skipped.", (Object)tableId);
            return;
        }
        LogMinerDmlEntry dmlEntry = this.selectLobParser.parse(row.getRedoSql(), table);
        dmlEntry.setObjectName(row.getTableName());
        dmlEntry.setObjectOwner(row.getTablespaceName());
        this.addToTransaction(row.getTransactionId(), row, () -> new SelectLobLocatorEvent(row, dmlEntry, this.selectLobParser.getColumnName(), this.selectLobParser.isBinary()));
        this.metrics.incrementRegisteredDmlCount();
    }

    protected void handleLobWrite(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_WRITE '{}' skipped", (Object)row);
            return;
        }
        LOGGER.trace("LOB_WRITE: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_WRITE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        if (row.getRedoSql() != null) {
            String lobWriteSql = this.parseLobWriteSql(row.getRedoSql());
            this.addToTransaction(row.getTransactionId(), row, () -> new LobWriteEvent(row, lobWriteSql));
        }
    }

    private void handleLobErase(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_ERASE '{}' skipped", (Object)row);
            return;
        }
        LOGGER.trace("LOB_ERASE: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_ERASE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> new LobEraseEvent(row));
    }

    protected void handleDataEvent(LogMinerEventRow row) throws SQLException, InterruptedException {
        if (row.getRedoSql() == null) {
            return;
        }
        LOGGER.trace("DML: {}", (Object)row);
        LOGGER.trace("\t{}", (Object)row.getRedoSql());
        ++this.counters.dmlCount;
        switch (row.getEventType()) {
            case INSERT: {
                ++this.counters.insertCount;
                break;
            }
            case UPDATE: {
                ++this.counters.updateCount;
                break;
            }
            case DELETE: {
                ++this.counters.deleteCount;
            }
        }
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            if (!this.getConfig().getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                return;
            }
            table = this.dispatchSchemaChangeEventAndGetTableForNewCapturedTable(tableId, this.offsetContext, this.dispatcher);
        }
        if (row.isRollbackFlag()) {
            Transaction transaction = this.getTransactionCache().get(row.getTransactionId());
            if (transaction == null) {
                LOGGER.warn("Cannot undo change '{}' since transaction was not found.", (Object)row);
            } else {
                transaction.removeEventWithRowId(row.getRowId());
            }
            return;
        }
        LogMinerDmlEntry dmlEntry = this.parseDmlStatement(row.getRedoSql(), table, row.getTransactionId());
        dmlEntry.setObjectName(row.getTableName());
        dmlEntry.setObjectOwner(row.getTablespaceName());
        this.addToTransaction(row.getTransactionId(), row, () -> new DmlEvent(row, dmlEntry));
        this.metrics.incrementRegisteredDmlCount();
    }

    protected void warnPotentiallyStuckScn(Scn previousOffsetScn, Scn previousOffsetCommitScn) {
        if (this.offsetContext != null && this.offsetContext.getCommitScn() != null) {
            Scn scn = this.offsetContext.getScn();
            Scn commitScn = this.offsetContext.getCommitScn();
            if (previousOffsetScn.equals(scn) && !previousOffsetCommitScn.equals(commitScn)) {
                ++this.counters.stuckCount;
                if (this.counters.stuckCount == 25) {
                    LOGGER.warn("Offset SCN {} has not changed in 25 mining session iterations. This indicates long running transaction(s) are active.  Commit SCN {}.", (Object)previousOffsetScn, (Object)previousOffsetCommitScn);
                    this.metrics.incrementScnFreezeCount();
                }
            } else {
                this.counters.stuckCount = 0;
            }
        }
    }

    private boolean hasNextWithMetricsUpdate(ResultSet resultSet) throws SQLException {
        Instant start = Instant.now();
        if (resultSet.next()) {
            this.metrics.addCurrentResultSetNext(Duration.between(start, Instant.now()));
            return true;
        }
        return false;
    }

    protected void addToTransaction(String transactionId, LogMinerEventRow row, Supplier<LogMinerEvent> eventSupplier) {
        if (this.isTransactionIdAllowed(transactionId)) {
            Transaction transaction = this.getTransactionCache().get(transactionId);
            if (transaction == null) {
                LOGGER.trace("Transaction {} not in cache, creating.", (Object)transactionId);
                transaction = new Transaction(transactionId, row.getScn(), row.getChangeTime());
                this.getTransactionCache().put(transactionId, transaction);
            }
            if (row.getHash() == 0L || !transaction.getHashes().contains(row.getHash())) {
                if (row.getHash() != 0L) {
                    transaction.getHashes().add(row.getHash());
                }
                LOGGER.trace("Adding {} to transaction {} for table '{}'.", new Object[]{row.getOperation(), transactionId, row.getTableId()});
                transaction.getEvents().add(eventSupplier.get());
                this.metrics.setActiveTransactions(this.getTransactionCache().size());
                this.metrics.calculateLagMetrics(row.getChangeTime());
            }
        }
    }

    private Table dispatchSchemaChangeEventAndGetTableForNewCapturedTable(TableId tableId, OracleOffsetContext offsetContext, EventDispatcher<TableId> dispatcher) throws SQLException, InterruptedException {
        LOGGER.info("Table '{}' is new and will now be captured.", (Object)tableId);
        offsetContext.event(tableId, Instant.now());
        dispatcher.dispatchSchemaChangeEvent(tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.partition, offsetContext, tableId, tableId.catalog(), tableId.schema(), this.getTableMetadataDdl(tableId), this.getSchema(), Instant.now(), this.metrics));
        return this.getSchema().tableFor(tableId);
    }

    private String getTableMetadataDdl(TableId tableId) throws SQLException {
        ++this.counters.tableMetadataCount;
        LOGGER.info("Getting database metadata for table '{}'", (Object)tableId);
        try (OracleConnection connection = new OracleConnection(this.connectorConfig.getJdbcConfig(), () -> this.getClass().getClassLoader());){
            String pdbName = this.getConfig().getPdbName();
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            String string = connection.getTableMetadataDdl(tableId);
            return string;
        }
    }

    private LogMinerDmlEntry parseDmlStatement(String redoSql, Table table, String transactionId) {
        LogMinerDmlEntry dmlEntry;
        try {
            Instant parseStart = Instant.now();
            dmlEntry = this.dmlParser.parse(redoSql, table, transactionId);
            this.metrics.addCurrentParseTime(Duration.between(parseStart, Instant.now()));
        }
        catch (DmlParserException e) {
            String message = "DML statement couldn't be parsed. Please open a Jira issue with the statement '" + redoSql + "'.";
            throw new DmlParserException(message, e);
        }
        if (dmlEntry.getOldValues().length == 0 && (EventType.UPDATE == dmlEntry.getEventType() || EventType.DELETE == dmlEntry.getEventType())) {
            LOGGER.warn("The DML event '{}' contained no before state.", (Object)redoSql);
            this.metrics.incrementWarningCount();
        }
        return dmlEntry;
    }

    private String parseLobWriteSql(String sql) {
        if (sql == null) {
            return null;
        }
        int start = sql.indexOf(":= '");
        if (start != -1) {
            int end = sql.lastIndexOf("'");
            return sql.substring(start + 4, end);
        }
        start = sql.indexOf(":= HEXTORAW");
        if (start != -1) {
            int end = sql.lastIndexOf("'") + 2;
            return sql.substring(start + 3, end);
        }
        throw new DebeziumException("Unable to parse unsupported LOB_WRITE SQL: " + sql);
    }

    protected class Counters {
        public int stuckCount;
        public int dmlCount;
        public int ddlCount;
        public int insertCount;
        public int updateCount;
        public int deleteCount;
        public int commitCount;
        public int rollbackCount;
        public int tableMetadataCount;
        public long rows;

        protected Counters() {
        }

        public void reset() {
            this.stuckCount = 0;
            this.dmlCount = 0;
            this.ddlCount = 0;
            this.insertCount = 0;
            this.updateCount = 0;
            this.deleteCount = 0;
            this.commitCount = 0;
            this.rollbackCount = 0;
            this.tableMetadataCount = 0;
            this.rows = 0L;
        }

        public String toString() {
            return "Counters{rows=" + this.rows + ", stuckCount=" + this.stuckCount + ", dmlCount=" + this.dmlCount + ", ddlCount=" + this.ddlCount + ", insertCount=" + this.insertCount + ", updateCount=" + this.updateCount + ", deleteCount=" + this.deleteCount + ", commitCount=" + this.commitCount + ", rollbackCount=" + this.rollbackCount + ", tableMetadataCount=" + this.tableMetadataCount + '}';
        }
    }
}

