/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser;

import java.util.Arrays;
import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.EventType;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;

public class LogMinerDmlEntryImpl
implements LogMinerDmlEntry {
    private final EventType eventType;
    private final Object[] newValues;
    private final Object[] oldValues;
    private String objectOwner;
    private String objectName;

    public LogMinerDmlEntryImpl(int eventType, Object[] newValues, Object[] oldValues, String owner, String name) {
        this.eventType = EventType.from(eventType);
        this.newValues = newValues;
        this.oldValues = oldValues;
        this.objectOwner = owner;
        this.objectName = name;
    }

    private LogMinerDmlEntryImpl(EventType eventType, Object[] newValues, Object[] oldValues) {
        this.eventType = eventType;
        this.newValues = newValues;
        this.oldValues = oldValues;
    }

    public static LogMinerDmlEntry forInsert(Object[] newColumnValues) {
        return new LogMinerDmlEntryImpl(EventType.INSERT, newColumnValues, new Object[0]);
    }

    public static LogMinerDmlEntry forUpdate(Object[] newColumnValues, Object[] oldColumnValues) {
        return new LogMinerDmlEntryImpl(EventType.UPDATE, newColumnValues, oldColumnValues);
    }

    public static LogMinerDmlEntry forDelete(Object[] oldColumnValues) {
        return new LogMinerDmlEntryImpl(EventType.DELETE, new Object[0], oldColumnValues);
    }

    public static LogMinerDmlEntry forLobLocator(Object[] newColumnValues) {
        Object[] oldColumnValues = Arrays.copyOf(newColumnValues, newColumnValues.length);
        return new LogMinerDmlEntryImpl(EventType.SELECT_LOB_LOCATOR, newColumnValues, oldColumnValues);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object[] getOldValues() {
        return this.oldValues;
    }

    @Override
    public Object[] getNewValues() {
        return this.newValues;
    }

    @Override
    public String getObjectOwner() {
        return this.objectOwner;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void setObjectName(String name) {
        this.objectName = name;
    }

    @Override
    public void setObjectOwner(String name) {
        this.objectOwner = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogMinerDmlEntryImpl that = (LogMinerDmlEntryImpl)o;
        return this.eventType == that.eventType && Arrays.equals(this.newValues, that.newValues) && Arrays.equals(this.oldValues, that.oldValues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.newValues, this.oldValues});
    }

    public String toString() {
        return "{LogMinerDmlEntryImpl={eventType=" + (Object)((Object)this.eventType) + ",newColumns=" + this.newValues + ",oldColumns=" + this.oldValues + "}";
    }
}

