/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Scn;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transaction.class);
    private String transactionId;
    private Scn startScn;
    private Instant changeTime;
    private List<LogMinerEvent> events;
    private Set<Long> hashes;

    public Transaction(String transactionId, Scn startScn, Instant changeTime, List<LogMinerEvent> events, Set<Long> hashes) {
        this.transactionId = transactionId;
        this.startScn = startScn;
        this.changeTime = changeTime;
        this.events = events;
        this.hashes = hashes;
    }

    public Transaction(String transactionId, Scn startScn, Instant changeTime) {
        this(transactionId, startScn, changeTime, new ArrayList<LogMinerEvent>(), new HashSet<Long>());
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public Scn getStartScn() {
        return this.startScn;
    }

    public Instant getChangeTime() {
        return this.changeTime;
    }

    public List<LogMinerEvent> getEvents() {
        return this.events;
    }

    public Set<Long> getHashes() {
        return this.hashes;
    }

    public void removeEventWithRowId(String rowId) {
        this.events.removeIf(event -> {
            if (event.getRowId().equals(rowId)) {
                LOGGER.trace("Undo applied for event {}.", event);
                return true;
            }
            return false;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId);
    }

    public String toString() {
        return "Transaction{transactionId='" + this.transactionId + '\'' + ", startScn=" + this.startScn + '}';
    }
}

