/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.logminer;

import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Scn;

public class LogFile {
    private final String fileName;
    private final Scn firstScn;
    private final Scn nextScn;
    private final Long sequence;
    private final boolean current;
    private final Type type;

    public LogFile(String fileName, Scn firstScn, Scn nextScn, Long sequence, Type type) {
        this(fileName, firstScn, nextScn, sequence, type, false);
    }

    public LogFile(String fileName, Scn firstScn, Scn nextScn, Long sequence, Type type, boolean current) {
        this.fileName = fileName;
        this.firstScn = firstScn;
        this.nextScn = nextScn;
        this.sequence = sequence;
        this.current = current;
        this.type = type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Scn getFirstScn() {
        return this.firstScn;
    }

    public Scn getNextScn() {
        return this.isCurrent() ? Scn.MAX : this.nextScn;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.sequence);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogFile)) {
            return false;
        }
        LogFile other = (LogFile)obj;
        return Objects.equals(this.sequence, other.sequence);
    }

    public static enum Type {
        ARCHIVE,
        REDO;

    }
}

