/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import java.sql.SQLException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.DebeziumException;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.jdbc.JdbcConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.DataChangeEventListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.SnapshotProgressListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;

public class OracleSignalBasedIncrementalSnapshotChangeEventSource
extends SignalBasedIncrementalSnapshotChangeEventSource<TableId> {
    private final String pdbName;
    private final OracleConnection connection;

    public OracleSignalBasedIncrementalSnapshotChangeEventSource(CommonConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener progressListener, DataChangeEventListener dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
        this.pdbName = ((OracleConnectorConfig)config).getPdbName();
        this.connection = (OracleConnection)jdbcConnection;
    }

    @Override
    protected String getSignalTableName(String dataCollectionId) {
        TableId tableId = TableId.parse(dataCollectionId);
        return tableId.schema() + "." + tableId.table();
    }

    @Override
    protected void preReadChunk(IncrementalSnapshotContext<TableId> context) {
        if (this.pdbName != null) {
            this.connection.setSessionToPdb(this.pdbName);
        }
    }

    @Override
    protected void postReadChunk(IncrementalSnapshotContext<TableId> context) {
        if (this.pdbName != null) {
            this.connection.resetSessionToCdb();
        }
    }

    @Override
    protected void postIncrementalSnapshotCompleted() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DebeziumException("Failed to close snapshot connection", e);
        }
    }
}

