/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleDatabaseVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?:.*)(?:Release )([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)(?:.*)");
    private static final Pattern VERSION_18_1_PATTERN = Pattern.compile("(?:.*)(?:\\- Production(?:\\r\\n|\\r|\\n)(?:Version ))([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.([0-9]+)");
    private final int major;
    private final int maintenance;
    private final int appServer;
    private final int component;
    private final int platform;
    private final String banner;

    private OracleDatabaseVersion(int major, int maintenance, int appServer, int component, int platform, String banner) {
        this.major = major;
        this.maintenance = maintenance;
        this.appServer = appServer;
        this.component = component;
        this.platform = platform;
        this.banner = banner;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMaintenance() {
        return this.maintenance;
    }

    public int getAppServer() {
        return this.appServer;
    }

    public int getComponent() {
        return this.component;
    }

    public int getPlatform() {
        return this.platform;
    }

    public String getBanner() {
        return this.banner;
    }

    public String toString() {
        return this.major + "." + this.maintenance + "." + this.appServer + "." + this.component + "." + this.platform;
    }

    public static OracleDatabaseVersion parse(String banner) {
        Matcher matcher = VERSION_18_1_PATTERN.matcher(banner);
        if (!matcher.matches() && !(matcher = VERSION_PATTERN.matcher(banner)).matches()) {
            throw new RuntimeException("Failed to resolve Oracle database version: '" + banner + "'");
        }
        int major = Integer.parseInt(matcher.group(1));
        int maintenance = Integer.parseInt(matcher.group(2));
        int app = Integer.parseInt(matcher.group(3));
        int component = Integer.parseInt(matcher.group(4));
        int platform = Integer.parseInt(matcher.group(5));
        return new OracleDatabaseVersion(major, maintenance, app, component, platform, banner);
    }
}

