/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleValueConverters;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.StreamingAdapter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.antlr.OracleDdlParser;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.HistorizedRelationalDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Table;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableSchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.Tables;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.SchemaChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.TopicSelector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.SchemaNameAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final OracleDdlParser ddlParser;
    private final OracleValueConverters valueConverters;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, OracleValueConverters valueConverters, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity) {
        super(connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder(valueConverters, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames()), StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)tableNameCaseSensitivity), connectorConfig.getKeyMapper());
        this.ddlParser = new OracleDdlParser(valueConverters, connectorConfig.getTableFilters().dataCollectionFilter());
        this.valueConverters = valueConverters;
    }

    public Tables getTables() {
        return this.tables();
    }

    public OracleValueConverters getValueConverters() {
        return this.valueConverters;
    }

    @Override
    public OracleDdlParser getDdlParser() {
        return this.ddlParser;
    }

    @Override
    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        switch (schemaChange.getType()) {
            case CREATE: 
            case ALTER: {
                schemaChange.getTableChanges().forEach(x -> {
                    this.buildAndRegisterSchema(x.getTable());
                    this.tables().overwriteTable(x.getTable());
                });
                break;
            }
            case DROP: {
                schemaChange.getTableChanges().forEach(x -> this.removeSchema(x.getId()));
                break;
            }
        }
        if (schemaChange.getTables().stream().map(Table::id).anyMatch(this.getTableFilter()::isIncluded)) {
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }
}

