/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Field;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.base.ChangeEventQueue;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.common.BaseSourceTask;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Module;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleChangeEventSourceFactory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleChangeEventSourceMetricsFactory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleErrorHandler;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleEventMetadataProvider;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleOffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OraclePartition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleTaskContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleTopicSelector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleValueConverters;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.StreamingAdapter;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.ChangeEventSourceCoordinator;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.DataChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.ErrorHandler;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.spi.Offsets;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.TopicSelector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.SchemaNameAdjuster;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorTask
extends BaseSourceTask<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorTask.class);
    private static final String CONTEXT_NAME = "oracle-connector-task";
    private volatile OracleTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile OracleConnection jdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile OracleDatabaseSchema schema;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public ChangeEventSourceCoordinator<OraclePartition, OracleOffsetContext> start(Configuration config) {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        TopicSelector<TableId> topicSelector = OracleTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        Configuration jdbcConfig = connectorConfig.getJdbcConfig();
        this.jdbcConnection = new OracleConnection(jdbcConfig, () -> this.getClass().getClassLoader());
        OracleValueConverters valueConverters = new OracleValueConverters(connectorConfig, this.jdbcConnection);
        StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity = connectorConfig.getAdapter().getTableNameCaseSensitivity(this.jdbcConnection);
        this.schema = new OracleDatabaseSchema(connectorConfig, valueConverters, schemaNameAdjuster, topicSelector, tableNameCaseSensitivity);
        this.schema.initializeStorage();
        Offsets<OraclePartition, OracleOffsetContext> previousOffsets = this.getPreviousOffsets(new OraclePartition.Provider(connectorConfig), connectorConfig.getAdapter().getOffsetContextLoader());
        OraclePartition partition = previousOffsets.getTheOnlyPartition();
        OracleOffsetContext previousOffset = previousOffsets.getTheOnlyOffset();
        if (previousOffset != null) {
            this.schema.recover(partition, previousOffset);
        }
        this.taskContext = new OracleTaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new OracleErrorHandler(connectorConfig.getLogicalName(), this.queue);
        OracleEventMetadataProvider metadataProvider = new OracleEventMetadataProvider();
        EventDispatcher<TableId> dispatcher = new EventDispatcher<TableId>(connectorConfig, topicSelector, this.schema, this.queue, connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, metadataProvider, schemaNameAdjuster);
        OracleStreamingChangeEventSourceMetrics streamingMetrics = new OracleStreamingChangeEventSourceMetrics(this.taskContext, this.queue, metadataProvider, connectorConfig);
        ChangeEventSourceCoordinator<OraclePartition, OracleOffsetContext> coordinator = new ChangeEventSourceCoordinator<OraclePartition, OracleOffsetContext>(previousOffsets, this.errorHandler, OracleConnector.class, connectorConfig, new OracleChangeEventSourceFactory(connectorConfig, this.jdbcConnection, this.errorHandler, dispatcher, clock, this.schema, jdbcConfig, this.taskContext, streamingMetrics), new OracleChangeEventSourceMetricsFactory(streamingMetrics), dispatcher, this.schema);
        coordinator.start(this.taskContext, this.queue, metadataProvider);
        return coordinator;
    }

    @Override
    public List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    @Override
    public void doStop() {
        try {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        this.schema.close();
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return OracleConnectorConfig.ALL_FIELDS;
    }
}

