/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.common.RelationalBaseSourceConnector;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.Module;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorTask;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalDatabaseConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigDef;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigValue;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnector.class);
    private Map<String, String> properties;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    @Override
    public Class<? extends Task> taskClass() {
        return OracleConnectorTask.class;
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    @Override
    public void stop() {
    }

    @Override
    public ConfigDef config() {
        return OracleConnectorConfig.configDef();
    }

    @Override
    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue databaseValue = configValues.get(RelationalDatabaseConnectorConfig.DATABASE_NAME.name());
        if (!databaseValue.errorMessages().isEmpty()) {
            return;
        }
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue userValue = configValues.get(RelationalDatabaseConnectorConfig.USER.name());
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        try (OracleConnection connection = new OracleConnection(connectorConfig.getJdbcConfig(), () -> this.getClass().getClassLoader());){
            LOGGER.debug("Successfully tested connection for {} with user '{}'", (Object)OracleConnection.connectionString(config), (Object)connection.username());
        }
        catch (RuntimeException | SQLException e) {
            LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{config.withMaskedPasswords(), userValue, e});
            hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
        }
    }

    @Override
    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(OracleConnectorConfig.ALL_FIELDS);
    }
}

