/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle;

import java.util.Optional;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleDatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleOffsetContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OraclePartition;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleSignalBasedIncrementalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.oracle.OracleTaskContext;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.jdbc.JdbcConnection;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.ErrorHandler;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.EventDispatcher;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.DataChangeEventListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.SnapshotProgressListener;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.TableId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DataCollectionId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DatabaseSchema;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;

public class OracleChangeEventSourceFactory
implements ChangeEventSourceFactory<OraclePartition, OracleOffsetContext> {
    private final OracleConnectorConfig configuration;
    private final OracleConnection jdbcConnection;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final Configuration jdbcConfig;
    private final OracleTaskContext taskContext;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;

    public OracleChangeEventSourceFactory(OracleConnectorConfig configuration, OracleConnection jdbcConnection, ErrorHandler errorHandler, EventDispatcher<TableId> dispatcher, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, OracleTaskContext taskContext, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.configuration = configuration;
        this.jdbcConnection = jdbcConnection;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.jdbcConfig = jdbcConfig;
        this.taskContext = taskContext;
        this.streamingMetrics = streamingMetrics;
    }

    @Override
    public SnapshotChangeEventSource<OraclePartition, OracleOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener snapshotProgressListener) {
        return new OracleSnapshotChangeEventSource(this.configuration, this.jdbcConnection, this.schema, this.dispatcher, this.clock, snapshotProgressListener);
    }

    @Override
    public StreamingChangeEventSource<OraclePartition, OracleOffsetContext> getStreamingChangeEventSource() {
        return this.configuration.getAdapter().getSource(this.jdbcConnection, this.dispatcher, this.errorHandler, this.clock, this.schema, this.taskContext, this.jdbcConfig, this.streamingMetrics);
    }

    @Override
    public Optional<IncrementalSnapshotChangeEventSource<? extends DataCollectionId>> getIncrementalSnapshotChangeEventSource(OracleOffsetContext offsetContext, SnapshotProgressListener snapshotProgressListener, DataChangeEventListener dataChangeEventListener) {
        if (Strings.isNullOrEmpty(this.configuration.getSignalingDataCollectionId())) {
            return Optional.empty();
        }
        return Optional.of(new OracleSignalBasedIncrementalSnapshotChangeEventSource((CommonConnectorConfig)this.configuration, (JdbcConnection)new OracleConnection(this.jdbcConnection.config(), () -> this.getClass().getClassLoader()), this.dispatcher, (DatabaseSchema<?>)this.schema, this.clock, snapshotProgressListener, dataChangeEventListener));
    }
}

