/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.common;

import java.util.ArrayList;
import java.util.Map;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.Configuration;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.relational.RelationalDatabaseConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Strings;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.Config;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.common.config.ConfigValue;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalBaseSourceConnector
extends SourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalBaseSourceConnector.class);

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map<String, ConfigValue> results = this.validateAllFields(config);
        ConfigValue hostnameValue = results.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue portValue = results.get(RelationalDatabaseConnectorConfig.PORT.name());
        ConfigValue userValue = results.get(RelationalDatabaseConnectorConfig.USER.name());
        ConfigValue passwordValue = results.get(RelationalDatabaseConnectorConfig.PASSWORD.name());
        String passwordStringValue = config.getString(RelationalDatabaseConnectorConfig.PASSWORD);
        if (Strings.isNullOrEmpty(passwordStringValue)) {
            LOGGER.debug("The connection password is empty");
        }
        if (hostnameValue.errorMessages().isEmpty() && portValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty() && passwordValue.errorMessages().isEmpty()) {
            this.validateConnection(results, config);
        }
        return new Config(new ArrayList<ConfigValue>(results.values()));
    }

    protected abstract void validateConnection(Map<String, ConfigValue> var1, Configuration var2);

    protected abstract Map<String, ConfigValue> validateAllFields(Configuration var1);
}

