/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.common;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.schema.DataCollectionId;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.Clock;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.util.LoggingContext;

public class CdcSourceTaskContext {
    private final String connectorType;
    private final String connectorName;
    private final Clock clock;
    private final Supplier<Collection<? extends DataCollectionId>> collectionsSupplier;

    public CdcSourceTaskContext(String connectorType, String connectorName, Supplier<Collection<? extends DataCollectionId>> collectionsSupplier) {
        this.connectorType = connectorType;
        this.connectorName = connectorName;
        this.collectionsSupplier = collectionsSupplier != null ? collectionsSupplier : Collections::emptyList;
        this.clock = Clock.system();
    }

    public LoggingContext.PreviousContext configureLoggingContext(String contextName) {
        return LoggingContext.forConnector(this.connectorType, this.connectorName, contextName);
    }

    public void temporaryLoggingContext(CommonConnectorConfig connectorConfig, String contextName, Runnable operation) {
        LoggingContext.temporarilyForConnector("MySQL", connectorConfig.getLogicalName(), contextName, operation);
    }

    public Clock getClock() {
        return this.clock;
    }

    public String[] capturedDataCollections() {
        return (String[])this.collectionsSupplier.get().stream().map(Object::toString).toArray(String[]::new);
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorName() {
        return this.connectorName;
    }
}

