/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector;

import java.time.Instant;
import java.util.Objects;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.config.CommonConnectorConfig;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.AbstractSourceInfo;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.SnapshotRecord;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.connector.SourceInfoStructMaker;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.data.Enum;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Struct;

public abstract class AbstractSourceInfoStructMaker<T extends AbstractSourceInfo>
implements SourceInfoStructMaker<T> {
    public static final Schema SNAPSHOT_RECORD_SCHEMA = Enum.builder("true,last,false").defaultValue("false").optional().build();
    private final String version;
    private final String connector;
    private final String serverName;

    public AbstractSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        this.connector = Objects.requireNonNull(connector);
        this.version = Objects.requireNonNull(version);
        this.serverName = connectorConfig.getLogicalName();
    }

    protected SchemaBuilder commonSchemaBuilder() {
        return SchemaBuilder.struct().field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("name", Schema.STRING_SCHEMA).field("ts_ms", Schema.INT64_SCHEMA).field("snapshot", SNAPSHOT_RECORD_SCHEMA).field("db", Schema.STRING_SCHEMA).field("sequence", Schema.OPTIONAL_STRING_SCHEMA);
    }

    protected Struct commonStruct(T sourceInfo) {
        SnapshotRecord snapshot;
        Instant timestamp = ((AbstractSourceInfo)sourceInfo).timestamp() == null ? Instant.now() : ((AbstractSourceInfo)sourceInfo).timestamp();
        String database = ((AbstractSourceInfo)sourceInfo).database() == null ? "" : ((AbstractSourceInfo)sourceInfo).database();
        Struct ret = new Struct(this.schema()).put("version", (Object)this.version).put("connector", (Object)this.connector).put("name", (Object)this.serverName).put("ts_ms", (Object)timestamp.toEpochMilli()).put("db", (Object)database);
        String sequence = ((AbstractSourceInfo)sourceInfo).sequence();
        if (sequence != null) {
            ret.put("sequence", (Object)sequence);
        }
        if ((snapshot = ((AbstractSourceInfo)sourceInfo).snapshot()) != null) {
            snapshot.toSource(ret);
        }
        return ret;
    }
}

