/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.inlong.audit.send.SenderChannel;
import org.apache.inlong.audit.send.SenderManager;
import org.apache.inlong.audit.util.IpPort;
import org.apache.inlong.audit.util.SenderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderGroup {
    private static final Logger logger = LoggerFactory.getLogger(SenderGroup.class);
    public static final int MAX_SEND_TIMES = 3;
    public static final int DEFAULT_WAIT_TIMES = 10000;
    public static final int WAIT_INTERVAL = 1;
    public static final int DEFAULT_SYNCH_REQUESTS = 1;
    public static final int RANDOM_MIN = 0;
    private List<LinkedBlockingQueue<SenderChannel>> channelGroups = new ArrayList<LinkedBlockingQueue<SenderChannel>>();
    private int mIndex = 0;
    private List<SenderChannel> deleteChannels = new ArrayList<SenderChannel>();
    private ConcurrentHashMap<String, SenderChannel> totalChannels = new ConcurrentHashMap();
    private int waitChannelTimes = 10000;
    private int waitChannelIntervalMs = 1;
    private int maxSynchRequest = 1;
    private boolean hasSendError = false;
    private SenderManager senderManager;

    public SenderGroup(SenderManager senderManager) {
        this.senderManager = senderManager;
        this.channelGroups.add(new LinkedBlockingQueue());
        this.channelGroups.add(new LinkedBlockingQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SenderResult send(ByteBuf dataBuf) {
        LinkedBlockingQueue<SenderChannel> channels = this.channelGroups.get(this.mIndex);
        SenderChannel channel = null;
        try {
            if (channels.size() <= 0) {
                logger.error("channels is empty");
                dataBuf.release();
                SenderResult senderResult = new SenderResult("channels is empty", 0, false);
                return senderResult;
            }
            boolean isOk = false;
            for (int tryIndex = 0; tryIndex < 3; ++tryIndex) {
                int random = 0 + (int)(Math.random() * (double)(channels.size() - 0));
                channels = this.channelGroups.get(this.mIndex);
                for (int i = 0; i < channels.size(); ++i) {
                    channel = channels.poll();
                    if (channel.tryAcquire()) {
                        if (random == i && channel.connect()) {
                            isOk = true;
                            break;
                        }
                        channel.release();
                    }
                    channels.offer(channel);
                    channel = null;
                }
                if (isOk) break;
                try {
                    Thread.sleep(this.waitChannelIntervalMs);
                    continue;
                }
                catch (Throwable e) {
                    logger.error(e.getMessage());
                }
            }
            if (channel == null) {
                logger.error("can not get a channel");
                dataBuf.release();
                SenderResult tryIndex = new SenderResult("can not get a channel", 0, false);
                return tryIndex;
            }
            ChannelFuture t = null;
            if (channel.getChannel().isWritable()) {
                t = channel.getChannel().writeAndFlush((Object)dataBuf).sync().await();
                if (!t.isSuccess()) {
                    if (!channel.getChannel().isActive()) {
                        channel.connect();
                    }
                    t = channel.getChannel().writeAndFlush((Object)dataBuf).sync().await();
                }
            } else {
                dataBuf.release();
            }
            SenderResult senderResult = new SenderResult(channel.getIpPort().ip, channel.getIpPort().port, t.isSuccess());
            return senderResult;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
            this.setHasSendError(true);
            SenderResult senderResult = new SenderResult(ex.getMessage(), 0, false);
            return senderResult;
        }
        finally {
            if (channel != null) {
                channel.release();
                channels.offer(channel);
            }
        }
    }

    public void release(String ipPort) {
        SenderChannel channel = this.totalChannels.get(ipPort);
        if (channel != null) {
            channel.release();
        }
    }

    public void release(InetSocketAddress addr) {
        int destPort;
        String destIp = addr.getHostName();
        String ipPort = IpPort.getIpPortKey(destIp, destPort = addr.getPort());
        SenderChannel channel = this.totalChannels.get(ipPort);
        if (channel != null) {
            channel.release();
        }
    }

    public void updateConfig(Set<String> ipLists) {
        try {
            for (SenderChannel dc : this.deleteChannels) {
                dc.getChannel().disconnect();
                dc.getChannel().close();
            }
            this.deleteChannels.clear();
            int newIndex = this.mIndex ^ 1;
            LinkedBlockingQueue<SenderChannel> newChannels = this.channelGroups.get(newIndex);
            newChannels.clear();
            for (String string : ipLists) {
                SenderChannel channel = this.totalChannels.get(string);
                if (channel != null) {
                    newChannels.add(channel);
                    continue;
                }
                try {
                    IpPort ipPortObj = IpPort.parseIpPort(string);
                    if (ipPortObj == null) continue;
                    channel = new SenderChannel(ipPortObj, this.maxSynchRequest, this.senderManager);
                    newChannels.add(channel);
                    this.totalChannels.put(string, channel);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            for (Map.Entry entry : this.totalChannels.entrySet()) {
                if (ipLists.contains(entry.getKey())) continue;
                this.deleteChannels.add((SenderChannel)entry.getValue());
            }
            for (SenderChannel senderChannel : this.deleteChannels) {
                this.totalChannels.remove(senderChannel.getIpPort().key);
            }
            this.mIndex = newIndex;
        }
        catch (Throwable e) {
            logger.error("Update Sender Ip Failed." + e.getMessage());
        }
    }

    public boolean isHasSendError() {
        return this.hasSendError;
    }

    public void setHasSendError(boolean hasSendError) {
        this.hasSendError = hasSendError;
    }
}

