/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.debezium.internal;

import com.ververica.cdc.debezium.internal.DebeziumOffset;
import com.ververica.cdc.debezium.internal.Handover;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.embedded.EmbeddedEngineChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.engine.ChangeEvent;
import org.apache.inlong.sort.cdc.oracle.shaded.io.debezium.engine.DebeziumEngine;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.inlong.sort.cdc.oracle.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DebeziumChangeConsumer
implements DebeziumEngine.ChangeConsumer<ChangeEvent<SourceRecord, SourceRecord>> {
    public static final String LAST_COMPLETELY_PROCESSED_LSN_KEY = "lsn_proc";
    public static final String LAST_COMMIT_LSN_KEY = "lsn_commit";
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumChangeConsumer.class);
    private final Handover handover;
    private volatile DebeziumEngine.RecordCommitter<ChangeEvent<SourceRecord, SourceRecord>> currentCommitter;

    public DebeziumChangeConsumer(Handover handover) {
        this.handover = handover;
    }

    @Override
    public void handleBatch(List<ChangeEvent<SourceRecord, SourceRecord>> events, DebeziumEngine.RecordCommitter<ChangeEvent<SourceRecord, SourceRecord>> recordCommitter) {
        try {
            this.currentCommitter = recordCommitter;
            this.handover.produce(events);
        }
        catch (Throwable e) {
            this.handover.reportError(e);
        }
    }

    public void commitOffset(DebeziumOffset offset) throws InterruptedException {
        if (this.currentCommitter == null) {
            LOG.info("commitOffset() called on Debezium change consumer which doesn't receive records yet.");
            return;
        }
        SourceRecord recordWrapper = new SourceRecord(offset.sourcePartition, this.adjustSourceOffset(offset.sourceOffset), "DUMMY", Schema.BOOLEAN_SCHEMA, true);
        EmbeddedEngineChangeEvent<Object, SourceRecord> changeEvent = new EmbeddedEngineChangeEvent<Object, SourceRecord>(null, recordWrapper, recordWrapper);
        this.currentCommitter.markProcessed(changeEvent);
        this.currentCommitter.markBatchFinished();
    }

    private Map<String, Object> adjustSourceOffset(Map<String, Object> sourceOffset) {
        String value;
        if (sourceOffset.containsKey(LAST_COMPLETELY_PROCESSED_LSN_KEY)) {
            value = sourceOffset.get(LAST_COMPLETELY_PROCESSED_LSN_KEY).toString();
            sourceOffset.put(LAST_COMPLETELY_PROCESSED_LSN_KEY, Long.parseLong(value));
        }
        if (sourceOffset.containsKey(LAST_COMMIT_LSN_KEY)) {
            value = sourceOffset.get(LAST_COMMIT_LSN_KEY).toString();
            sourceOffset.put(LAST_COMMIT_LSN_KEY, Long.parseLong(value));
        }
        return sourceOffset;
    }
}

