/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.table;

import com.ververica.cdc.connectors.oracle.OracleSource;
import com.ververica.cdc.connectors.oracle.table.OracleDeserializationConverterFactory;
import com.ververica.cdc.connectors.oracle.table.OracleReadableMetaData;
import com.ververica.cdc.connectors.oracle.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumSourceFunction;
import com.ververica.cdc.debezium.table.MetadataConverter;
import com.ververica.cdc.debezium.table.RowDataDebeziumDeserializeSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class OracleTableSource
implements ScanTableSource,
SupportsReadingMetadata {
    private final ResolvedSchema physicalSchema;
    private final int port;
    private final String hostname;
    private final String database;
    private final String username;
    private final String password;
    private final String tableName;
    private final String schemaName;
    private final Properties dbzProperties;
    private final StartupOptions startupOptions;
    protected DataType producedDataType;
    protected List<String> metadataKeys;

    public OracleTableSource(ResolvedSchema physicalSchema, int port, String hostname, String database, String tableName, String schemaName, String username, String password, Properties dbzProperties, StartupOptions startupOptions) {
        this.physicalSchema = physicalSchema;
        this.port = port;
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.schemaName = (String)Preconditions.checkNotNull((Object)schemaName);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
        this.dbzProperties = dbzProperties;
        this.startupOptions = startupOptions;
        this.producedDataType = physicalSchema.toPhysicalRowDataType();
        this.metadataKeys = Collections.emptyList();
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        RowType physicalDataType = (RowType)this.physicalSchema.toPhysicalRowDataType().getLogicalType();
        MetadataConverter[] metadataConverters = this.getMetadataConverters();
        TypeInformation typeInfo = scanContext.createTypeInformation(this.producedDataType);
        RowDataDebeziumDeserializeSchema deserializer = RowDataDebeziumDeserializeSchema.newBuilder().setPhysicalRowType(physicalDataType).setMetadataConverters(metadataConverters).setResultTypeInfo((TypeInformation<RowData>)typeInfo).setUserDefinedConverterFactory(OracleDeserializationConverterFactory.instance()).build();
        OracleSource.Builder<RowData> builder = OracleSource.builder().hostname(this.hostname).port(this.port).database(this.database).tableList(this.schemaName + "." + this.tableName).schemaList(this.schemaName).username(this.username).password(this.password).debeziumProperties(this.dbzProperties).startupOptions(this.startupOptions).deserializer(deserializer);
        DebeziumSourceFunction<RowData> sourceFunction = builder.build();
        return SourceFunctionProvider.of(sourceFunction, (boolean)false);
    }

    private MetadataConverter[] getMetadataConverters() {
        if (this.metadataKeys.isEmpty()) {
            return new MetadataConverter[0];
        }
        return (MetadataConverter[])this.metadataKeys.stream().map(key -> Stream.of(OracleReadableMetaData.values()).filter(m -> m.getKey().equals(key)).findFirst().orElseThrow(IllegalStateException::new)).map(OracleReadableMetaData::getConverter).toArray(MetadataConverter[]::new);
    }

    public DynamicTableSource copy() {
        OracleTableSource source = new OracleTableSource(this.physicalSchema, this.port, this.hostname, this.database, this.tableName, this.schemaName, this.username, this.password, this.dbzProperties, this.startupOptions);
        source.metadataKeys = this.metadataKeys;
        source.producedDataType = this.producedDataType;
        return source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OracleTableSource that = (OracleTableSource)o;
        return this.port == that.port && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.database, that.database) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.dbzProperties, that.dbzProperties) && Objects.equals(this.startupOptions, that.startupOptions) && Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.physicalSchema, this.port, this.hostname, this.database, this.username, this.password, this.tableName, this.schemaName, this.dbzProperties, this.startupOptions, this.producedDataType, this.metadataKeys);
    }

    public String asSummaryString() {
        return "Oracle-CDC";
    }

    public Map<String, DataType> listReadableMetadata() {
        return Stream.of(OracleReadableMetaData.values()).collect(Collectors.toMap(OracleReadableMetaData::getKey, OracleReadableMetaData::getDataType));
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        this.metadataKeys = metadataKeys;
        this.producedDataType = producedDataType;
    }
}

