/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;

public class SubscriptionStatsImpl
implements SubscriptionStats {
    public double msgRateOut;
    public double msgThroughputOut;
    public long bytesOutCounter;
    public long msgOutCounter;
    public double msgRateRedeliver;
    public int chunkedMessageRate;
    public long msgBacklog;
    public long backlogSize;
    public long msgBacklogNoDelayed;
    public boolean blockedSubscriptionOnUnackedMsgs;
    public long msgDelayed;
    public long unackedMessages;
    public String type;
    public String activeConsumerName;
    public double msgRateExpired;
    public long totalMsgExpired;
    public long lastExpireTimestamp;
    public long lastConsumedFlowTimestamp;
    public long lastConsumedTimestamp;
    public long lastAckedTimestamp;
    public long lastMarkDeleteAdvancedTimestamp;
    public List<ConsumerStatsImpl> consumers = new ArrayList<ConsumerStatsImpl>();
    public boolean isDurable;
    public boolean isReplicated;
    public Map<String, String> consumersAfterMarkDeletePosition = new LinkedHashMap<String, String>();
    public int nonContiguousDeletedMessagesRanges;
    public int nonContiguousDeletedMessagesRangesSerializedSize;

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.bytesOutCounter = 0L;
        this.msgOutCounter = 0L;
        this.msgRateRedeliver = 0.0;
        this.msgBacklog = 0L;
        this.backlogSize = 0L;
        this.msgBacklogNoDelayed = 0L;
        this.unackedMessages = 0L;
        this.msgRateExpired = 0.0;
        this.totalMsgExpired = 0L;
        this.lastExpireTimestamp = 0L;
        this.lastMarkDeleteAdvancedTimestamp = 0L;
        this.consumers.clear();
        this.consumersAfterMarkDeletePosition.clear();
        this.nonContiguousDeletedMessagesRanges = 0;
        this.nonContiguousDeletedMessagesRangesSerializedSize = 0;
    }

    public SubscriptionStatsImpl add(SubscriptionStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.bytesOutCounter += stats.bytesOutCounter;
        this.msgOutCounter += stats.msgOutCounter;
        this.msgRateRedeliver += stats.msgRateRedeliver;
        this.msgBacklog += stats.msgBacklog;
        this.backlogSize += stats.backlogSize;
        this.msgBacklogNoDelayed += stats.msgBacklogNoDelayed;
        this.msgDelayed += stats.msgDelayed;
        this.unackedMessages += stats.unackedMessages;
        this.msgRateExpired += stats.msgRateExpired;
        this.totalMsgExpired += stats.totalMsgExpired;
        this.isReplicated |= stats.isReplicated;
        this.isDurable |= stats.isDurable;
        if (this.consumers.size() != stats.consumers.size()) {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                ConsumerStatsImpl consumerStats = new ConsumerStatsImpl();
                this.consumers.add(consumerStats.add(stats.consumers.get(i)));
            }
        } else {
            for (int i = 0; i < stats.consumers.size(); ++i) {
                this.consumers.get(i).add(stats.consumers.get(i));
            }
        }
        this.consumersAfterMarkDeletePosition.putAll(stats.consumersAfterMarkDeletePosition);
        this.nonContiguousDeletedMessagesRanges += stats.nonContiguousDeletedMessagesRanges;
        this.nonContiguousDeletedMessagesRangesSerializedSize += stats.nonContiguousDeletedMessagesRangesSerializedSize;
        return this;
    }

    @Override
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    @Override
    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    @Override
    public long getBytesOutCounter() {
        return this.bytesOutCounter;
    }

    @Override
    public long getMsgOutCounter() {
        return this.msgOutCounter;
    }

    @Override
    public double getMsgRateRedeliver() {
        return this.msgRateRedeliver;
    }

    @Override
    public int getChunkedMessageRate() {
        return this.chunkedMessageRate;
    }

    @Override
    public long getMsgBacklog() {
        return this.msgBacklog;
    }

    @Override
    public long getBacklogSize() {
        return this.backlogSize;
    }

    @Override
    public long getMsgBacklogNoDelayed() {
        return this.msgBacklogNoDelayed;
    }

    @Override
    public boolean isBlockedSubscriptionOnUnackedMsgs() {
        return this.blockedSubscriptionOnUnackedMsgs;
    }

    @Override
    public long getMsgDelayed() {
        return this.msgDelayed;
    }

    @Override
    public long getUnackedMessages() {
        return this.unackedMessages;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getActiveConsumerName() {
        return this.activeConsumerName;
    }

    @Override
    public double getMsgRateExpired() {
        return this.msgRateExpired;
    }

    @Override
    public long getTotalMsgExpired() {
        return this.totalMsgExpired;
    }

    @Override
    public long getLastExpireTimestamp() {
        return this.lastExpireTimestamp;
    }

    @Override
    public long getLastConsumedFlowTimestamp() {
        return this.lastConsumedFlowTimestamp;
    }

    @Override
    public long getLastConsumedTimestamp() {
        return this.lastConsumedTimestamp;
    }

    @Override
    public long getLastAckedTimestamp() {
        return this.lastAckedTimestamp;
    }

    @Override
    public long getLastMarkDeleteAdvancedTimestamp() {
        return this.lastMarkDeleteAdvancedTimestamp;
    }

    public List<ConsumerStatsImpl> getConsumers() {
        return this.consumers;
    }

    @Override
    public boolean isDurable() {
        return this.isDurable;
    }

    @Override
    public boolean isReplicated() {
        return this.isReplicated;
    }

    @Override
    public Map<String, String> getConsumersAfterMarkDeletePosition() {
        return this.consumersAfterMarkDeletePosition;
    }

    @Override
    public int getNonContiguousDeletedMessagesRanges() {
        return this.nonContiguousDeletedMessagesRanges;
    }

    @Override
    public int getNonContiguousDeletedMessagesRangesSerializedSize() {
        return this.nonContiguousDeletedMessagesRangesSerializedSize;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setBytesOutCounter(long bytesOutCounter) {
        this.bytesOutCounter = bytesOutCounter;
    }

    public void setMsgOutCounter(long msgOutCounter) {
        this.msgOutCounter = msgOutCounter;
    }

    public void setMsgRateRedeliver(double msgRateRedeliver) {
        this.msgRateRedeliver = msgRateRedeliver;
    }

    public void setChunkedMessageRate(int chunkedMessageRate) {
        this.chunkedMessageRate = chunkedMessageRate;
    }

    public void setMsgBacklog(long msgBacklog) {
        this.msgBacklog = msgBacklog;
    }

    public void setBacklogSize(long backlogSize) {
        this.backlogSize = backlogSize;
    }

    public void setMsgBacklogNoDelayed(long msgBacklogNoDelayed) {
        this.msgBacklogNoDelayed = msgBacklogNoDelayed;
    }

    public void setBlockedSubscriptionOnUnackedMsgs(boolean blockedSubscriptionOnUnackedMsgs) {
        this.blockedSubscriptionOnUnackedMsgs = blockedSubscriptionOnUnackedMsgs;
    }

    public void setMsgDelayed(long msgDelayed) {
        this.msgDelayed = msgDelayed;
    }

    public void setUnackedMessages(long unackedMessages) {
        this.unackedMessages = unackedMessages;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setActiveConsumerName(String activeConsumerName) {
        this.activeConsumerName = activeConsumerName;
    }

    public void setMsgRateExpired(double msgRateExpired) {
        this.msgRateExpired = msgRateExpired;
    }

    public void setTotalMsgExpired(long totalMsgExpired) {
        this.totalMsgExpired = totalMsgExpired;
    }

    public void setLastExpireTimestamp(long lastExpireTimestamp) {
        this.lastExpireTimestamp = lastExpireTimestamp;
    }

    public void setLastConsumedFlowTimestamp(long lastConsumedFlowTimestamp) {
        this.lastConsumedFlowTimestamp = lastConsumedFlowTimestamp;
    }

    public void setLastConsumedTimestamp(long lastConsumedTimestamp) {
        this.lastConsumedTimestamp = lastConsumedTimestamp;
    }

    public void setLastAckedTimestamp(long lastAckedTimestamp) {
        this.lastAckedTimestamp = lastAckedTimestamp;
    }

    public void setLastMarkDeleteAdvancedTimestamp(long lastMarkDeleteAdvancedTimestamp) {
        this.lastMarkDeleteAdvancedTimestamp = lastMarkDeleteAdvancedTimestamp;
    }

    public void setConsumers(List<ConsumerStatsImpl> consumers) {
        this.consumers = consumers;
    }

    public void setDurable(boolean isDurable) {
        this.isDurable = isDurable;
    }

    public void setReplicated(boolean isReplicated) {
        this.isReplicated = isReplicated;
    }

    public void setConsumersAfterMarkDeletePosition(Map<String, String> consumersAfterMarkDeletePosition) {
        this.consumersAfterMarkDeletePosition = consumersAfterMarkDeletePosition;
    }

    public void setNonContiguousDeletedMessagesRanges(int nonContiguousDeletedMessagesRanges) {
        this.nonContiguousDeletedMessagesRanges = nonContiguousDeletedMessagesRanges;
    }

    public void setNonContiguousDeletedMessagesRangesSerializedSize(int nonContiguousDeletedMessagesRangesSerializedSize) {
        this.nonContiguousDeletedMessagesRangesSerializedSize = nonContiguousDeletedMessagesRangesSerializedSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionStatsImpl)) {
            return false;
        }
        SubscriptionStatsImpl other = (SubscriptionStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (this.getBytesOutCounter() != other.getBytesOutCounter()) {
            return false;
        }
        if (this.getMsgOutCounter() != other.getMsgOutCounter()) {
            return false;
        }
        if (Double.compare(this.getMsgRateRedeliver(), other.getMsgRateRedeliver()) != 0) {
            return false;
        }
        if (this.getChunkedMessageRate() != other.getChunkedMessageRate()) {
            return false;
        }
        if (this.getMsgBacklog() != other.getMsgBacklog()) {
            return false;
        }
        if (this.getBacklogSize() != other.getBacklogSize()) {
            return false;
        }
        if (this.getMsgBacklogNoDelayed() != other.getMsgBacklogNoDelayed()) {
            return false;
        }
        if (this.isBlockedSubscriptionOnUnackedMsgs() != other.isBlockedSubscriptionOnUnackedMsgs()) {
            return false;
        }
        if (this.getMsgDelayed() != other.getMsgDelayed()) {
            return false;
        }
        if (this.getUnackedMessages() != other.getUnackedMessages()) {
            return false;
        }
        if (Double.compare(this.getMsgRateExpired(), other.getMsgRateExpired()) != 0) {
            return false;
        }
        if (this.getTotalMsgExpired() != other.getTotalMsgExpired()) {
            return false;
        }
        if (this.getLastExpireTimestamp() != other.getLastExpireTimestamp()) {
            return false;
        }
        if (this.getLastConsumedFlowTimestamp() != other.getLastConsumedFlowTimestamp()) {
            return false;
        }
        if (this.getLastConsumedTimestamp() != other.getLastConsumedTimestamp()) {
            return false;
        }
        if (this.getLastAckedTimestamp() != other.getLastAckedTimestamp()) {
            return false;
        }
        if (this.getLastMarkDeleteAdvancedTimestamp() != other.getLastMarkDeleteAdvancedTimestamp()) {
            return false;
        }
        if (this.isDurable() != other.isDurable()) {
            return false;
        }
        if (this.isReplicated() != other.isReplicated()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRanges() != other.getNonContiguousDeletedMessagesRanges()) {
            return false;
        }
        if (this.getNonContiguousDeletedMessagesRangesSerializedSize() != other.getNonContiguousDeletedMessagesRangesSerializedSize()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$activeConsumerName = this.getActiveConsumerName();
        String other$activeConsumerName = other.getActiveConsumerName();
        if (this$activeConsumerName == null ? other$activeConsumerName != null : !this$activeConsumerName.equals(other$activeConsumerName)) {
            return false;
        }
        List<ConsumerStatsImpl> this$consumers = this.getConsumers();
        List<ConsumerStatsImpl> other$consumers = other.getConsumers();
        if (this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers)) {
            return false;
        }
        Map<String, String> this$consumersAfterMarkDeletePosition = this.getConsumersAfterMarkDeletePosition();
        Map<String, String> other$consumersAfterMarkDeletePosition = other.getConsumersAfterMarkDeletePosition();
        return !(this$consumersAfterMarkDeletePosition == null ? other$consumersAfterMarkDeletePosition != null : !((Object)this$consumersAfterMarkDeletePosition).equals(other$consumersAfterMarkDeletePosition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $bytesOutCounter = this.getBytesOutCounter();
        result = result * 59 + (int)($bytesOutCounter >>> 32 ^ $bytesOutCounter);
        long $msgOutCounter = this.getMsgOutCounter();
        result = result * 59 + (int)($msgOutCounter >>> 32 ^ $msgOutCounter);
        long $msgRateRedeliver = Double.doubleToLongBits(this.getMsgRateRedeliver());
        result = result * 59 + (int)($msgRateRedeliver >>> 32 ^ $msgRateRedeliver);
        result = result * 59 + this.getChunkedMessageRate();
        long $msgBacklog = this.getMsgBacklog();
        result = result * 59 + (int)($msgBacklog >>> 32 ^ $msgBacklog);
        long $backlogSize = this.getBacklogSize();
        result = result * 59 + (int)($backlogSize >>> 32 ^ $backlogSize);
        long $msgBacklogNoDelayed = this.getMsgBacklogNoDelayed();
        result = result * 59 + (int)($msgBacklogNoDelayed >>> 32 ^ $msgBacklogNoDelayed);
        result = result * 59 + (this.isBlockedSubscriptionOnUnackedMsgs() ? 79 : 97);
        long $msgDelayed = this.getMsgDelayed();
        result = result * 59 + (int)($msgDelayed >>> 32 ^ $msgDelayed);
        long $unackedMessages = this.getUnackedMessages();
        result = result * 59 + (int)($unackedMessages >>> 32 ^ $unackedMessages);
        long $msgRateExpired = Double.doubleToLongBits(this.getMsgRateExpired());
        result = result * 59 + (int)($msgRateExpired >>> 32 ^ $msgRateExpired);
        long $totalMsgExpired = this.getTotalMsgExpired();
        result = result * 59 + (int)($totalMsgExpired >>> 32 ^ $totalMsgExpired);
        long $lastExpireTimestamp = this.getLastExpireTimestamp();
        result = result * 59 + (int)($lastExpireTimestamp >>> 32 ^ $lastExpireTimestamp);
        long $lastConsumedFlowTimestamp = this.getLastConsumedFlowTimestamp();
        result = result * 59 + (int)($lastConsumedFlowTimestamp >>> 32 ^ $lastConsumedFlowTimestamp);
        long $lastConsumedTimestamp = this.getLastConsumedTimestamp();
        result = result * 59 + (int)($lastConsumedTimestamp >>> 32 ^ $lastConsumedTimestamp);
        long $lastAckedTimestamp = this.getLastAckedTimestamp();
        result = result * 59 + (int)($lastAckedTimestamp >>> 32 ^ $lastAckedTimestamp);
        long $lastMarkDeleteAdvancedTimestamp = this.getLastMarkDeleteAdvancedTimestamp();
        result = result * 59 + (int)($lastMarkDeleteAdvancedTimestamp >>> 32 ^ $lastMarkDeleteAdvancedTimestamp);
        result = result * 59 + (this.isDurable() ? 79 : 97);
        result = result * 59 + (this.isReplicated() ? 79 : 97);
        result = result * 59 + this.getNonContiguousDeletedMessagesRanges();
        result = result * 59 + this.getNonContiguousDeletedMessagesRangesSerializedSize();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $activeConsumerName = this.getActiveConsumerName();
        result = result * 59 + ($activeConsumerName == null ? 43 : $activeConsumerName.hashCode());
        List<ConsumerStatsImpl> $consumers = this.getConsumers();
        result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
        Map<String, String> $consumersAfterMarkDeletePosition = this.getConsumersAfterMarkDeletePosition();
        result = result * 59 + ($consumersAfterMarkDeletePosition == null ? 43 : ((Object)$consumersAfterMarkDeletePosition).hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionStatsImpl(msgRateOut=" + this.getMsgRateOut() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCounter=" + this.getBytesOutCounter() + ", msgOutCounter=" + this.getMsgOutCounter() + ", msgRateRedeliver=" + this.getMsgRateRedeliver() + ", chunkedMessageRate=" + this.getChunkedMessageRate() + ", msgBacklog=" + this.getMsgBacklog() + ", backlogSize=" + this.getBacklogSize() + ", msgBacklogNoDelayed=" + this.getMsgBacklogNoDelayed() + ", blockedSubscriptionOnUnackedMsgs=" + this.isBlockedSubscriptionOnUnackedMsgs() + ", msgDelayed=" + this.getMsgDelayed() + ", unackedMessages=" + this.getUnackedMessages() + ", type=" + this.getType() + ", activeConsumerName=" + this.getActiveConsumerName() + ", msgRateExpired=" + this.getMsgRateExpired() + ", totalMsgExpired=" + this.getTotalMsgExpired() + ", lastExpireTimestamp=" + this.getLastExpireTimestamp() + ", lastConsumedFlowTimestamp=" + this.getLastConsumedFlowTimestamp() + ", lastConsumedTimestamp=" + this.getLastConsumedTimestamp() + ", lastAckedTimestamp=" + this.getLastAckedTimestamp() + ", lastMarkDeleteAdvancedTimestamp=" + this.getLastMarkDeleteAdvancedTimestamp() + ", consumers=" + this.getConsumers() + ", isDurable=" + this.isDurable() + ", isReplicated=" + this.isReplicated() + ", consumersAfterMarkDeletePosition=" + this.getConsumersAfterMarkDeletePosition() + ", nonContiguousDeletedMessagesRanges=" + this.getNonContiguousDeletedMessagesRanges() + ", nonContiguousDeletedMessagesRangesSerializedSize=" + this.getNonContiguousDeletedMessagesRangesSerializedSize() + ")";
    }
}

