/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.pulsar.withoutadmin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceSinkUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.flink.util.StringUtils;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMetadataReader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PulsarMetadataReader.class);
    public static final ConfigOption<String> AUTHENTICATION_TOKEN = ConfigOptions.key((String)"authentication-token").noDefaultValue().withDescription("Authentication token for connection.");
    private final String serverUrl;
    private final ClientConfigurationData clientConf;
    private final String subscriptionName;
    private final Map<String, String> caseInsensitiveParams;
    private final int indexOfThisSubtask;
    private final int numParallelSubtasks;
    private final PulsarClient client;
    private volatile boolean closed = false;
    private Set<TopicRange> seenTopics = new HashSet<TopicRange>();
    private final boolean useExternalSubscription;
    private final SerializableRange range;

    public PulsarMetadataReader(String serverUrl, ClientConfigurationData clientConf, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks, boolean useExternalSubscription) throws PulsarClientException {
        this.serverUrl = serverUrl;
        this.clientConf = clientConf;
        this.subscriptionName = subscriptionName;
        this.caseInsensitiveParams = caseInsensitiveParams;
        this.indexOfThisSubtask = indexOfThisSubtask;
        this.numParallelSubtasks = numParallelSubtasks;
        this.useExternalSubscription = useExternalSubscription;
        this.client = this.buildPulsarClient(serverUrl, clientConf, caseInsensitiveParams.get(AUTHENTICATION_TOKEN.key()));
        this.range = this.buildRange(caseInsensitiveParams);
    }

    private PulsarClient buildPulsarClient(String serviceUrl, ClientConfigurationData clientConf, String authentication) throws PulsarClientException {
        if (StringUtils.isNullOrWhitespaceOnly((String)authentication)) {
            return new PulsarClientImpl(clientConf);
        }
        return PulsarClient.builder().serviceUrl(serviceUrl).authentication(AuthenticationFactory.token(authentication)).build();
    }

    private SerializableRange buildRange(Map<String, String> caseInsensitiveParams) {
        if (this.numParallelSubtasks <= 0 || this.indexOfThisSubtask < 0) {
            return SerializableRange.ofFullRange();
        }
        if (caseInsensitiveParams == null || caseInsensitiveParams.isEmpty() || !caseInsensitiveParams.containsKey("enable-key-hash-range")) {
            return SerializableRange.ofFullRange();
        }
        String enableKeyHashRange = caseInsensitiveParams.get("enable-key-hash-range");
        if (!Boolean.parseBoolean(enableKeyHashRange)) {
            return SerializableRange.ofFullRange();
        }
        Range range = SourceSinkUtils.distributeRange(this.numParallelSubtasks, this.indexOfThisSubtask);
        return SerializableRange.of(range);
    }

    public PulsarMetadataReader(String serverUrl, ClientConfigurationData clientConf, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks) throws PulsarClientException {
        this(serverUrl, clientConf, subscriptionName, caseInsensitiveParams, indexOfThisSubtask, numParallelSubtasks, false);
    }

    @Override
    public void close() throws PulsarClientException {
        this.closed = true;
        this.client.close();
    }

    public Set<TopicRange> discoverTopicChanges() throws PulsarClientException, ClosedException {
        if (!this.closed) {
            Set<TopicRange> currentTopics = this.getTopicPartitionRanges();
            Sets.SetView<TopicRange> addedTopics = Sets.difference(currentTopics, this.seenTopics);
            this.seenTopics = currentTopics;
            return addedTopics;
        }
        throw new ClosedException();
    }

    public SerializableRange getRange() {
        return this.range;
    }

    public Set<TopicRange> getTopicPartitionRanges() throws PulsarClientException {
        Set<String> topics = this.getTopicPartitions();
        return topics.stream().filter(t -> SourceSinkUtils.belongsTo(t, this.range, this.numParallelSubtasks, this.indexOfThisSubtask)).map(t -> new TopicRange((String)t, this.range.getPulsarRange())).collect(Collectors.toSet());
    }

    public Set<String> getTopicPartitions() throws PulsarClientException {
        List<String> topics = this.getTopics();
        HashSet<String> allTopics = new HashSet<String>();
        for (String topic : topics) {
            int partNum = 1;
            try {
                List<String> partitions = this.client.getPartitionsForTopic(topic).get();
                partNum = partitions.size() == 1 && partitions.get(0).equals(topic) ? 0 : partitions.size();
            }
            catch (InterruptedException | ExecutionException e) {
                log.info("topic<{}> is not exit or execute error.", (Object)topic, (Object)e);
                throw new PulsarClientException(e);
            }
            if (partNum == 0) {
                allTopics.add(topic);
                continue;
            }
            for (int i = 0; i < partNum; ++i) {
                allTopics.add(topic + "-partition-" + i);
            }
        }
        return allTopics;
    }

    private List<String> getTopics() {
        for (Map.Entry<String, String> e : this.caseInsensitiveParams.entrySet()) {
            if (!PulsarOptions.TOPIC_OPTION_KEYS.contains(e.getKey())) continue;
            switch (e.getKey()) {
                case "topic": {
                    return Collections.singletonList(TopicName.get(e.getValue()).toString());
                }
                case "topics": {
                    return Arrays.asList(e.getValue().split(",")).stream().filter(s2 -> !s2.isEmpty()).map(t -> TopicName.get(t).toString()).collect(Collectors.toList());
                }
            }
            throw new IllegalArgumentException("Unknown pulsar topic option: " + e.getKey());
        }
        return Collections.emptyList();
    }

    public static class ClosedException
    extends Exception {
    }
}

