/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.pulsar.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.pulsar.FlinkPulsarSink;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarClientUtils;
import org.apache.flink.streaming.connectors.pulsar.table.PulsarSinkSemantic;
import org.apache.flink.streaming.util.serialization.PulsarSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.pulsar.table.DynamicPulsarSerializationSchema;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;

public class PulsarDynamicTableSink
implements DynamicTableSink,
SupportsWritingMetadata {
    protected final DataType physicalDataType;
    protected final String topic;
    protected final String serviceUrl;
    protected final String adminUrl;
    protected final Properties properties;
    @Nullable
    protected final EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat;
    protected final EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat;
    protected final int[] keyProjection;
    protected final int[] valueProjection;
    @Nullable
    protected final String keyPrefix;
    protected final boolean upsertMode;
    @Nullable
    protected final Integer parallelism;
    protected final PulsarSinkSemantic semantic;
    private final String formatType;
    private final MessageRouter messageRouter;
    protected List<String> metadataKeys;

    protected PulsarDynamicTableSink(String serviceUrl, String adminUrl, String topic, DataType physicalDataType, Properties properties, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, PulsarSinkSemantic semantic, String formatType, boolean upsertMode, @Nullable Integer parallelism, @Nullable MessageRouter messageRouter) {
        this.serviceUrl = (String)Preconditions.checkNotNull((Object)serviceUrl, (String)"serviceUrl data type must not be null.");
        this.adminUrl = (String)Preconditions.checkNotNull((Object)adminUrl, (String)"adminUrl data type must not be null.");
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Consumed data type must not be null.");
        this.metadataKeys = Collections.emptyList();
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.keyEncodingFormat = keyEncodingFormat;
        this.valueEncodingFormat = (EncodingFormat)Preconditions.checkNotNull(valueEncodingFormat, (String)"Encoding format must not be null.");
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection, (String)"Key projection must not be null.");
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection, (String)"Value projection must not be null.");
        this.keyPrefix = keyPrefix;
        this.semantic = (PulsarSinkSemantic)((Object)Preconditions.checkNotNull((Object)((Object)semantic), (String)"Semantic must not be null."));
        this.formatType = (String)Preconditions.checkNotNull((Object)formatType, (String)"FormatType must not be null.");
        this.upsertMode = upsertMode;
        this.parallelism = parallelism;
        this.messageRouter = messageRouter;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.valueEncodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema<RowData> keySerialization = this.createSerialization(context, this.keyEncodingFormat, this.keyProjection, this.keyPrefix);
        SerializationSchema<RowData> valueSerialization = this.createSerialization(context, this.valueEncodingFormat, this.valueProjection, null);
        PulsarSerializationSchema<RowData> pulsarSerializer = this.createPulsarSerializer(keySerialization, valueSerialization);
        SinkFunction<RowData> pulsarSink = this.createPulsarSink(this.topic, this.properties, pulsarSerializer);
        return SinkFunctionProvider.of(pulsarSink, (Integer)this.parallelism);
    }

    private PulsarSerializationSchema<RowData> createPulsarSerializer(SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization) {
        List physicalChildren = this.physicalDataType.getLogicalType().getChildren();
        RowData.FieldGetter[] keyFieldGetters = (RowData.FieldGetter[])Arrays.stream(this.keyProjection).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
        RowData.FieldGetter[] valueFieldGetters = (RowData.FieldGetter[])Arrays.stream(this.valueProjection).mapToObj(targetField -> RowData.createFieldGetter((LogicalType)((LogicalType)physicalChildren.get(targetField)), (int)targetField)).toArray(RowData.FieldGetter[]::new);
        int[] metadataPositions = Stream.of(WritableMetadata.values()).mapToInt(m3 -> {
            int pos = this.metadataKeys.indexOf(m3.key);
            if (pos < 0) {
                return -1;
            }
            return physicalChildren.size() + pos;
        }).toArray();
        boolean hasMetadata = this.metadataKeys.size() > 0;
        long delayMilliseconds = Optional.ofNullable(this.properties.getProperty("send-delay-millisecond", "0")).filter(StringUtils::isNumeric).map(Long::valueOf).orElse(0L);
        return new DynamicPulsarSerializationSchema(keySerialization, valueSerialization, keyFieldGetters, valueFieldGetters, hasMetadata, metadataPositions, this.upsertMode, DataTypeUtils.projectRow((DataType)this.physicalDataType, (int[])this.valueProjection), this.formatType, delayMilliseconds);
    }

    private SinkFunction<RowData> createPulsarSink(String topic, Properties properties, PulsarSerializationSchema<RowData> pulsarSerializer) {
        ClientConfigurationData configurationData = PulsarClientUtils.newClientConf(this.serviceUrl, properties);
        return new FlinkPulsarSink(this.adminUrl, Optional.ofNullable(topic), configurationData, properties, (PulsarSerializationSchema)pulsarSerializer, this.messageRouter, PulsarSinkSemantic.valueOf(this.semantic.toString()));
    }

    public MessageRouter getMessageRouter() {
        return this.messageRouter;
    }

    @Nullable
    private SerializationSchema<RowData> createSerialization(DynamicTableSink.Context context, @Nullable EncodingFormat<SerializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.physicalDataType, (int[])projection);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (SerializationSchema)format.createRuntimeEncoder(context, physicalFormatDataType);
    }

    public DynamicTableSink copy() {
        PulsarDynamicTableSink copy = new PulsarDynamicTableSink(this.serviceUrl, this.adminUrl, this.topic, this.physicalDataType, this.properties, this.keyEncodingFormat, this.valueEncodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.semantic, this.formatType, this.upsertMode, this.parallelism, this.messageRouter);
        copy.metadataKeys = this.metadataKeys;
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PulsarDynamicTableSink)) {
            return false;
        }
        PulsarDynamicTableSink that = (PulsarDynamicTableSink)o;
        return this.upsertMode == that.upsertMode && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.topic, that.topic) && Objects.equals(this.serviceUrl, that.serviceUrl) && Objects.equals(this.adminUrl, that.adminUrl) && Objects.equals(this.properties, that.properties) && Objects.equals(this.keyEncodingFormat, that.keyEncodingFormat) && Objects.equals(this.valueEncodingFormat, that.valueEncodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.parallelism, that.parallelism) && this.semantic == that.semantic && Objects.equals(this.formatType, that.formatType) && Objects.equals(this.messageRouter, that.messageRouter);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.metadataKeys, this.physicalDataType, this.topic, this.serviceUrl, this.adminUrl, this.properties, this.keyEncodingFormat, this.valueEncodingFormat, this.keyPrefix, this.upsertMode, this.parallelism, this.semantic, this.formatType, this.messageRouter});
        result = 31 * result + Arrays.hashCode(this.keyProjection);
        result = 31 * result + Arrays.hashCode(this.valueProjection);
        return result;
    }

    public String asSummaryString() {
        return "Pulsar dynamic table sink";
    }

    public Map<String, DataType> listWritableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(WritableMetadata.values()).forEachOrdered(m3 -> metadataMap.put(m3.key, m3.dataType));
        return metadataMap;
    }

    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        this.metadataKeys = metadataKeys;
    }

    static enum WritableMetadata {
        PROPERTIES("properties", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), (row, pos) -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            MapData map = row.getMap(pos);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            Properties properties = new Properties();
            for (int i = 0; i < keyArray.size(); ++i) {
                if (keyArray.isNullAt(i) || valueArray.isNullAt(i)) continue;
                String key = keyArray.getString(i).toString();
                String value = valueArray.getString(i).toString();
                properties.put(key, value);
            }
            return properties;
        }),
        EVENT_TIME("eventTime", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).nullable(), (row, pos) -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            return row.getTimestamp(pos, 3).getMillisecond();
        });

        final String key;
        final DataType dataType;
        final DynamicPulsarSerializationSchema.MetadataConverter converter;

        private WritableMetadata(String key, DataType dataType, DynamicPulsarSerializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

