/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;

public abstract class AbstractDynamicSchemaFormat<T> {
    public static final Pattern PATTERN = Pattern.compile("\\$\\{\\s*([\\w.-]+)\\s*}", 2);

    public List<String> extractValues(byte[] message, String ... keys) throws IOException {
        if (keys == null || keys.length == 0) {
            return new ArrayList<String>();
        }
        return this.extractValues(this.deserialize(message), keys);
    }

    public List<String> extractValues(T data, String ... keys) {
        if (keys == null || keys.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>(keys.length);
        for (String key : keys) {
            values.add(this.extract(data, key));
        }
        return values;
    }

    public abstract String extract(T var1, String var2);

    public abstract List<String> extractPrimaryKeyNames(T var1);

    public List<String> extractPrimaryKeyValues(byte[] message) throws IOException {
        return this.extractPrimaryKeyValues(this.deserialize(message));
    }

    public List<String> extractPrimaryKeyValues(T data) {
        List<String> pkNames = this.extractPrimaryKeyNames(data);
        if (pkNames == null || pkNames.isEmpty()) {
            return new ArrayList<String>();
        }
        return this.extractValues(data, pkNames.toArray(new String[0]));
    }

    public abstract boolean extractDDLFlag(T var1);

    public RowType extractSchema(T data) {
        return this.extractSchema(data, this.extractPrimaryKeyNames(data));
    }

    public abstract RowType extractSchema(T var1, List<String> var2);

    public List<RowData> extractRowData(T data) {
        return this.extractRowData(data, this.extractSchema(data));
    }

    public abstract List<RowData> extractRowData(T var1, RowType var2);

    public abstract T deserialize(byte[] var1) throws IOException;

    public String parse(byte[] message, String pattern) throws IOException {
        return this.parse(this.deserialize(message), pattern);
    }

    public abstract String parse(T var1, String var2) throws IOException;
}

