/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.file;

import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.audit.file.ConfigHolder;
import org.apache.inlong.audit.file.holder.PropertiesConfigHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    private static final Map<String, ConfigHolder> holderMap = new ConcurrentHashMap<String, ConfigHolder>();
    private static ConfigManager instance = null;
    private static String DEFAULT_CONFIG_PROPERTIES = "server.properties";

    public static ConfigManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance(String fileName, boolean needToCheckChanged) {
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            ConfigHolder holder;
            if (instance == null) {
                instance = new ConfigManager();
            }
            if ((holder = holderMap.get(fileName)) == null) {
                holder = new PropertiesConfigHolder(fileName, needToCheckChanged);
                holder.loadFromFileToHolder();
                holderMap.putIfAbsent(fileName, holder);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, String> getProperties(String fileName) {
        ConfigHolder holder = holderMap.get(fileName);
        if (holder != null) {
            return holder.getHolder();
        }
        return null;
    }

    private boolean updatePropertiesHolder(Map<String, String> result, String holderName, boolean addElseRemove) {
        if (StringUtils.isNotEmpty((CharSequence)holderName)) {
            PropertiesConfigHolder holder = (PropertiesConfigHolder)holderMap.get(holderName + ".properties");
            return this.updatePropertiesHolder(result, holder, true);
        }
        return true;
    }

    private boolean updatePropertiesHolder(Map<String, String> result, PropertiesConfigHolder holder, boolean addElseRemove) {
        Map<String, String> tmpHolder = holder.forkHolder();
        boolean changed = false;
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String oldValue;
            String string = oldValue = addElseRemove ? tmpHolder.put(entry.getKey(), entry.getValue()) : tmpHolder.remove(entry.getKey());
            if (oldValue != null && oldValue.equals(entry.getValue()) && addElseRemove) continue;
            changed = true;
        }
        if (changed) {
            return holder.loadFromHolderToFile(tmpHolder);
        }
        return false;
    }

    public ConfigHolder getDefaultConfigHolder() {
        return holderMap.get(DEFAULT_CONFIG_PROPERTIES);
    }

    public ConfigHolder getConfigHolder(String fileName) {
        return holderMap.get(fileName);
    }

    static {
        instance = ConfigManager.getInstance(DEFAULT_CONFIG_PROPERTIES, true);
        ReloadConfigWorker reloadProperties = new ReloadConfigWorker(instance);
        reloadProperties.setDaemon(true);
        reloadProperties.start();
    }

    private static class ReloadConfigWorker
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(ReloadConfigWorker.class);
        private final ConfigManager configManager;
        private final CloseableHttpClient httpClient;
        private final Gson gson = new Gson();
        private boolean isRunning = true;

        public ReloadConfigWorker(ConfigManager managerInstance) {
            this.configManager = managerInstance;
            this.httpClient = this.constructHttpClient();
        }

        private synchronized CloseableHttpClient constructHttpClient() {
            long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return httpClientBuilder.build();
        }

        public int getRandom(int min2, int max) {
            return (int)(Math.random() * (double)(max + 1 - min2)) + min2;
        }

        private long getSleepTime() {
            String sleepTimeInMsStr = this.configManager.getProperties(DEFAULT_CONFIG_PROPERTIES).get("configCheckIntervalMs");
            long sleepTimeInMs = 10000L;
            try {
                if (sleepTimeInMsStr != null) {
                    sleepTimeInMs = Long.parseLong(sleepTimeInMsStr);
                }
            }
            catch (Exception ignored) {
                LOG.info("ignored Exception ", (Throwable)ignored);
            }
            return sleepTimeInMs + (long)this.getRandom(0, 5000);
        }

        public void close() {
            this.isRunning = false;
        }

        private void checkLocalFile() {
            for (ConfigHolder holder : holderMap.values()) {
                boolean isChanged = holder.checkAndUpdateHolder();
                if (!isChanged) continue;
                holder.executeCallbacks();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkWithManager(String host) {
            HttpGet httpGet = null;
            try {
                String url = "http://" + host + "/inlong/manager/openapi/audit/getConfig";
                LOG.info("start to request {} to get config info", (Object)url);
                httpGet = new HttpGet(url);
                httpGet.addHeader("Connection", "close");
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
                String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
                Map configJsonMap = (Map)this.gson.fromJson(returnStr, Map.class);
                if (configJsonMap != null && configJsonMap.size() > 0) {
                    for (Map.Entry entry : configJsonMap.entrySet()) {
                        Map valueMap = (Map)this.gson.fromJson((String)entry.getValue(), Map.class);
                        this.configManager.updatePropertiesHolder((Map<String, String>)valueMap, (String)entry.getKey(), true);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("exception caught", (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
            return true;
        }

        private void checkRemoteConfig() {
            try {
                String[] hostList;
                String managerHosts = this.configManager.getProperties(DEFAULT_CONFIG_PROPERTIES).get("manager_hosts");
                for (String host : hostList = StringUtils.split((String)managerHosts, (String)",")) {
                    if (this.checkWithManager(host)) break;
                }
            }
            catch (Exception ex) {
                LOG.error("exception caught", (Throwable)ex);
            }
        }

        @Override
        public void run() {
            long count = 0L;
            while (this.isRunning) {
                long sleepTimeInMs = this.getSleepTime();
                ++count;
                try {
                    this.checkLocalFile();
                    if (count % 3L == 0L) {
                        this.checkRemoteConfig();
                        count = 0L;
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepTimeInMs);
                }
                catch (Exception ex) {
                    LOG.error("exception caught", (Throwable)ex);
                }
            }
        }
    }
}

