/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;

public class TypeInformationUtils {
    private static final Map<Class<?>, List<TypeInformation<?>>> typeInfoPerDocument = new ConcurrentHashMap();
    private static final Map<Class<?>, TypeInformation<Row>> rowInfoPerDocument = new ConcurrentHashMap();

    public static TypeInformation<Row> getTypesAsRow(Class<?> documentFormat) {
        return rowInfoPerDocument.computeIfAbsent(documentFormat, documentFormat1 -> {
            List<TypeInformation<?>> columnTypes = TypeInformationUtils.getColumnTypes(documentFormat1);
            TypeInformation[] typeInfos = columnTypes.toArray(new TypeInformation[0]);
            List<String> fieldNames = TypeInformationUtils.getFieldNames(documentFormat1);
            return new RowTypeInfo(typeInfos, fieldNames.toArray(new String[0]));
        });
    }

    private static List<String> getFieldNames(Class<?> documentFormat) {
        List fields = FieldUtils.getAllFieldsList(documentFormat);
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static List<TypeInformation<?>> getColumnTypes(Class<?> documentFormat) {
        return typeInfoPerDocument.computeIfAbsent(documentFormat, documentFormat1 -> {
            List fields = FieldUtils.getAllFieldsList((Class)documentFormat1);
            ArrayList<TypeInformation> typeInfos = new ArrayList<TypeInformation>();
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                typeInfos.add(TypeInformation.of(field.getType()));
            }
            return typeInfos;
        });
    }
}

