/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava18.com.google.common.base.CaseFormat;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class SourceSinkUtils {
    public static Map<String, String> validateStreamSourceOptions(Map<String, String> parameters) {
        Map<String, String> caseInsensitiveParams = parameters.entrySet().stream().collect(Collectors.toMap(t -> ((String)t.getKey()).toLowerCase(Locale.ROOT), t -> (String)t.getValue()));
        return SourceSinkUtils.validateSourceOptions(caseInsensitiveParams);
    }

    private static Map<String, String> validateSourceOptions(Map<String, String> caseInsensitiveParams) {
        Map<String, String> topicOptions = caseInsensitiveParams.entrySet().stream().filter(t -> PulsarOptions.TOPIC_OPTION_KEYS.contains(t.getKey())).collect(Collectors.toMap(map -> (String)map.getKey(), map -> (String)map.getValue()));
        if (topicOptions.isEmpty() || topicOptions.size() > 1) {
            throw new IllegalArgumentException("You should specify topic(s) using one of the topic options: " + StringUtils.join(PulsarOptions.TOPIC_OPTION_KEYS, ","));
        }
        for (Map.Entry<String, String> topicEntry : topicOptions.entrySet()) {
            String key = topicEntry.getKey();
            String value = topicEntry.getValue();
            if (key.equals("topic")) {
                if (!value.contains(",")) continue;
                throw new IllegalArgumentException("Use `topics` instead of `topic` for multi topic read");
            }
            if (key.equals("topics")) {
                List topics = Arrays.asList(value.split(",")).stream().map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
                if (!topics.isEmpty()) continue;
                throw new IllegalArgumentException("No topics is specified for read with option" + value);
            }
            if (value.trim().length() != 0) continue;
            throw new IllegalArgumentException("TopicsPattern is empty");
        }
        return caseInsensitiveParams;
    }

    public static boolean belongsTo(String topic, SerializableRange range, int numParallelSubtasks, int index) {
        if (range.isFullRange()) {
            if (topic.contains("-partition-")) {
                int pos = topic.lastIndexOf("-partition-");
                String topicPrefix = topic.substring(0, pos);
                String topicPartitionIndex = topic.substring(pos + "-partition-".length());
                if (topicPartitionIndex.matches("0|[1-9]\\d*")) {
                    int startIndex = (topicPrefix.hashCode() * 31 & Integer.MAX_VALUE) % numParallelSubtasks;
                    return (startIndex + Integer.valueOf(topicPartitionIndex)) % numParallelSubtasks == index;
                }
            }
            return (topic.hashCode() * 31 & Integer.MAX_VALUE) % numParallelSubtasks == index;
        }
        return true;
    }

    public static long getPartitionDiscoveryIntervalInMillis(Map<String, String> parameters) {
        String interval = parameters.getOrDefault("partition.discovery.interval-millis", "-1");
        return Long.parseLong(interval);
    }

    public static int getSendTimeoutMs(Map<String, String> parameters) {
        String interval = parameters.getOrDefault("send-timeout-ms", "30000");
        return Integer.parseInt(interval);
    }

    public static int getPollTimeoutMs(Map<String, String> parameters) {
        String interval = parameters.getOrDefault("poll-timeout-ms", "120000");
        return Integer.parseInt(interval);
    }

    public static boolean getUseMetrics(Map<String, String> parameters) {
        String useMetrics = parameters.getOrDefault("key-disable-metrics", "false");
        return Boolean.parseBoolean(useMetrics);
    }

    public static int getCommitMaxRetries(Map<String, String> parameters) {
        String retries = parameters.getOrDefault("commit-max-retries", "3");
        return Integer.parseInt(retries);
    }

    public static int getClientCacheSize(Map<String, String> parameters) {
        String size = parameters.getOrDefault("client-cache-size", "5");
        return Integer.parseInt(size);
    }

    public static boolean flushOnCheckpoint(Map<String, String> parameters) {
        String b = parameters.getOrDefault("flush-on-checkpoint", "true");
        return Boolean.parseBoolean(b);
    }

    public static boolean failOnWrite(Map<String, String> parameters) {
        String b = parameters.getOrDefault("fail-on-write", "true");
        return Boolean.parseBoolean(b);
    }

    public static long getTransactionTimeout(Map<String, String> parameters) {
        String value = parameters.getOrDefault("transaction-timeout", "3600000");
        return Long.parseLong(value);
    }

    public static long getMaxBlockTimeMs(Map<String, String> parameters) {
        String value = parameters.getOrDefault("max-block-time-ms", "100000");
        return Long.parseLong(value);
    }

    public static Map<String, Object> getReaderParams(Map<String, String> parameters) {
        return parameters.keySet().stream().filter(k -> k.startsWith("pulsar.reader.")).collect(Collectors.toMap(k -> k.substring("pulsar.reader.".length()), k -> (String)parameters.get(k)));
    }

    public static Map<String, String> toCaceInsensitiveParams(Map<String, String> parameters) {
        return parameters.entrySet().stream().collect(Collectors.toMap(t -> ((String)t.getKey()).toLowerCase(Locale.ROOT), t -> (String)t.getValue()));
    }

    public static Map<String, Object> getProducerParams(Map<String, String> parameters) {
        return parameters.keySet().stream().filter(k -> k.startsWith("pulsar.producer.")).collect(Collectors.toMap(k -> k.substring("pulsar.producer.".length()), k -> (String)parameters.get(k)));
    }

    public static Range distributeRange(int countOfSubTasks, int indexOfSubTasks) {
        int subTasksEndKey;
        int subTasksStartKey;
        int countOfKey = 65536;
        int part = countOfKey / countOfSubTasks;
        int remainder = countOfKey % countOfSubTasks;
        if (indexOfSubTasks < remainder) {
            subTasksStartKey = indexOfSubTasks * ++part;
            subTasksEndKey = indexOfSubTasks * part + part;
        } else {
            subTasksStartKey = indexOfSubTasks * part + remainder;
            subTasksEndKey = indexOfSubTasks * part + part + remainder;
        }
        return Range.of(subTasksStartKey, --subTasksEndKey);
    }

    public static int getOldStateVersion(Map<String, String> caseInsensitiveParams, int defaultValue) {
        String value = caseInsensitiveParams.get("old-state-version");
        if (StringUtils.isBlank(value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean getFailOnDataLossAndRemoveKey(Map<String, Object> readerConf) {
        String key = "failOnDataLoss";
        if (!readerConf.containsKey(key)) {
            key = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, key);
        }
        String failOnDataLossVal = readerConf.getOrDefault(key, "true").toString();
        boolean value = Boolean.parseBoolean(failOnDataLossVal);
        readerConf.remove(key);
        return value;
    }

    public static boolean getUseEarliestWhenDataLossAndRemoveKey(Map<String, Object> readerConf) {
        String failOnDataLossVal = readerConf.getOrDefault("use-earliest-when-data-loss", "false").toString();
        boolean value = Boolean.parseBoolean(failOnDataLossVal);
        readerConf.remove("use-earliest-when-data-loss");
        return value;
    }
}

