/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.streaming.connectors.pulsar.internal.IncompatibleSchemaException;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarClientUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.PulsarOptions;
import org.apache.flink.streaming.connectors.pulsar.internal.SchemaUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.SerializableRange;
import org.apache.flink.streaming.connectors.pulsar.internal.SourceSinkUtils;
import org.apache.flink.streaming.connectors.pulsar.internal.TopicRange;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.PartitionedTopicInternalStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMetadataReader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PulsarMetadataReader.class);
    private final String adminUrl;
    private final ClientConfigurationData clientConf;
    private final String subscriptionName;
    private final Map<String, String> caseInsensitiveParams;
    private final int indexOfThisSubtask;
    private final int numParallelSubtasks;
    private final PulsarAdmin admin;
    private volatile boolean closed = false;
    private Set<TopicRange> seenTopics = new HashSet<TopicRange>();
    private final boolean useExternalSubscription;
    private final SerializableRange range;

    public PulsarMetadataReader(String adminUrl, ClientConfigurationData clientConf, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks, boolean useExternalSubscription) throws PulsarClientException {
        this.adminUrl = adminUrl;
        this.clientConf = clientConf;
        this.subscriptionName = subscriptionName;
        this.caseInsensitiveParams = caseInsensitiveParams;
        this.indexOfThisSubtask = indexOfThisSubtask;
        this.numParallelSubtasks = numParallelSubtasks;
        this.useExternalSubscription = useExternalSubscription;
        this.admin = PulsarClientUtils.newAdminFromConf(adminUrl, clientConf);
        this.range = this.buildRange(caseInsensitiveParams);
    }

    private SerializableRange buildRange(Map<String, String> caseInsensitiveParams) {
        if (this.numParallelSubtasks <= 0 || this.indexOfThisSubtask < 0) {
            return SerializableRange.ofFullRange();
        }
        if (caseInsensitiveParams == null || caseInsensitiveParams.isEmpty() || !caseInsensitiveParams.containsKey("enable-key-hash-range")) {
            return SerializableRange.ofFullRange();
        }
        String enableKeyHashRange = caseInsensitiveParams.get("enable-key-hash-range");
        if (!Boolean.parseBoolean(enableKeyHashRange)) {
            return SerializableRange.ofFullRange();
        }
        Range range = SourceSinkUtils.distributeRange(this.numParallelSubtasks, this.indexOfThisSubtask);
        return SerializableRange.of(range);
    }

    public PulsarMetadataReader(String adminUrl, ClientConfigurationData clientConf, String subscriptionName, Map<String, String> caseInsensitiveParams, int indexOfThisSubtask, int numParallelSubtasks) throws PulsarClientException {
        this(adminUrl, clientConf, subscriptionName, caseInsensitiveParams, indexOfThisSubtask, numParallelSubtasks, false);
    }

    @Override
    public void close() {
        this.closed = true;
        this.admin.close();
    }

    public Set<TopicRange> discoverTopicChanges() throws PulsarAdminException, ClosedException {
        if (!this.closed) {
            Set<TopicRange> currentTopics = this.getTopicPartitionRanges();
            Sets.SetView<TopicRange> addedTopics = Sets.difference(currentTopics, this.seenTopics);
            this.seenTopics = currentTopics;
            return addedTopics;
        }
        throw new ClosedException();
    }

    public void createTenant(String tenant) throws PulsarAdminException {
        HashSet<String> clusters = new HashSet<String>(this.admin.clusters().getClusters());
        this.admin.tenants().createTenant(tenant, ((TenantInfoImpl.TenantInfoImplBuilder)TenantInfoImpl.builder().allowedClusters(clusters)).build());
    }

    public boolean tenantExists(String tenant) throws PulsarAdminException {
        try {
            this.admin.tenants().getTenantInfo(tenant);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        return true;
    }

    public List<String> listNamespaces() throws PulsarAdminException {
        List<String> tenants = this.admin.tenants().getTenants();
        ArrayList<String> namespaces = new ArrayList<String>();
        for (String tenant : tenants) {
            namespaces.addAll(this.admin.namespaces().getNamespaces(tenant));
        }
        return namespaces;
    }

    public boolean namespaceExists(String ns) throws PulsarAdminException {
        try {
            this.admin.namespaces().getTopics(ns);
        }
        catch (PulsarAdminException.NotFoundException e) {
            return false;
        }
        return true;
    }

    public void createNamespace(String ns) throws PulsarAdminException {
        this.createNamespace(ns, false);
    }

    public void createNamespace(String ns, boolean retain) throws PulsarAdminException {
        String nsName = NamespaceName.get(ns).toString();
        this.admin.namespaces().createNamespace(nsName);
        if (retain) {
            this.admin.namespaces().setRetention(nsName, new RetentionPolicies(-1, -1));
        }
    }

    public void deleteNamespace(String ns) throws PulsarAdminException {
        String nsName = NamespaceName.get(ns).toString();
        this.admin.namespaces().deleteNamespace(nsName);
    }

    public List<String> getTopics(String ns) throws PulsarAdminException {
        List<String> nonPartitionedTopics = this.getNonPartitionedTopics(ns);
        List<String> partitionedTopics = this.admin.topics().getPartitionedTopicList(ns);
        ArrayList allTopics = new ArrayList();
        Stream.of(partitionedTopics, nonPartitionedTopics).forEach(allTopics::addAll);
        return allTopics.stream().map(t -> TopicName.get(t).getLocalName()).collect(Collectors.toList());
    }

    public boolean topicExists(String topicName) throws PulsarAdminException {
        try {
            PartitionedTopicMetadata partitionedTopicMetadata = this.admin.topics().getPartitionedTopicMetadata(topicName);
            if (partitionedTopicMetadata.partitions > 0) {
                return true;
            }
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    public void deleteTopic(String topicName) throws PulsarAdminException {
        try {
            PartitionedTopicInternalStats partitionedInternalStats = this.admin.topics().getPartitionedInternalStats(topicName);
            Optional<PersistentTopicInternalStats> any = partitionedInternalStats.partitions.entrySet().stream().map(Map.Entry::getValue).filter(p -> !p.cursors.isEmpty()).findAny();
            if (any.isPresent()) {
                throw new IllegalStateException(String.format("The topic[%s] cannot be deleted because there are subscribers", topicName));
            }
            this.admin.topics().deletePartitionedTopic(topicName, true);
        }
        catch (PulsarAdminException.NotFoundException e) {
            log.warn("topic<{}> is not exit, try delete force it", (Object)topicName);
            this.admin.topics().delete(topicName, true);
        }
    }

    public void createTopic(String topicName, int partitionNum) throws PulsarAdminException, IncompatibleSchemaException {
        if (partitionNum > 0) {
            this.admin.topics().createPartitionedTopic(topicName, partitionNum);
        } else {
            this.admin.topics().createNonPartitionedTopic(topicName);
        }
    }

    public void uploadSchema(String topicName, SchemaInfo schemaInfo) throws IncompatibleSchemaException {
        SchemaUtils.uploadPulsarSchema(this.admin, topicName, schemaInfo);
    }

    public void deleteSchema(String topicName) {
        SchemaUtils.deletePulsarSchema(this.admin, topicName);
    }

    public void setupCursor(Map<TopicRange, MessageId> offset, boolean failOnDataLoss) {
        if (!this.useExternalSubscription || !failOnDataLoss) {
            for (Map.Entry<TopicRange, MessageId> entry : offset.entrySet()) {
                String subscriptionName = this.subscriptionNameFrom(entry.getKey());
                try {
                    log.info("Setting up subscription {} on topic {} at position {}", new Object[]{subscriptionName, entry.getKey(), entry.getValue()});
                    this.admin.topics().createSubscription(entry.getKey().getTopic(), subscriptionName, entry.getValue());
                    log.info("Subscription {} on topic {} at position {} finished", new Object[]{subscriptionName, entry.getKey(), entry.getValue()});
                }
                catch (PulsarAdminException.ConflictException e) {
                    log.info("Subscription {} on topic {} already exists", (Object)subscriptionName, (Object)entry.getKey());
                }
                catch (PulsarAdminException e) {
                    throw new RuntimeException(String.format("Failed to set up cursor for %s ", entry.getKey().toString()), e);
                }
            }
        }
    }

    public void setupCursor(Map<TopicRange, MessageId> offset) {
        this.setupCursor(offset, true);
    }

    public void commitOffsetToCursor(Map<TopicRange, MessageId> offset) {
        for (Map.Entry<TopicRange, MessageId> entry : offset.entrySet()) {
            TopicRange tp = entry.getKey();
            try {
                log.info("Committing offset {} to topic {}", (Object)entry.getValue(), (Object)tp);
                this.admin.topics().resetCursor(tp.getTopic(), this.subscriptionNameFrom(tp), entry.getValue(), true);
                log.info("Successfully committed offset {} to topic {}", (Object)entry.getValue(), (Object)tp);
            }
            catch (Throwable e) {
                if (e instanceof PulsarAdminException && (((PulsarAdminException)e).getStatusCode() == 404 || ((PulsarAdminException)e).getStatusCode() == 412)) {
                    log.info("Cannot commit cursor since the topic {} has been deleted during execution", (Object)tp);
                    continue;
                }
                throw new RuntimeException(String.format("Failed to commit cursor for %s", tp), e);
            }
        }
    }

    public void removeCursor(Set<TopicRange> topics) throws ClosedException {
        if (this.closed) {
            throw new ClosedException();
        }
        if (!this.useExternalSubscription) {
            for (TopicRange topicRange : topics) {
                String subscriptionName = this.subscriptionNameFrom(topicRange);
                try {
                    log.info("Removing subscription {} from topic {}", (Object)subscriptionName, (Object)topicRange.getTopic());
                    this.admin.topics().deleteSubscription(topicRange.getTopic(), subscriptionName);
                    log.info("Successfully removed subscription {} from topic {}", (Object)subscriptionName, (Object)topicRange.getTopic());
                }
                catch (Throwable e) {
                    if (e instanceof PulsarAdminException && ((PulsarAdminException)e).getStatusCode() == 404) {
                        log.info("Cannot remove cursor since the topic {} has been deleted during execution", (Object)topicRange.getTopic());
                        continue;
                    }
                    throw new RuntimeException(String.format("Failed to remove cursor for %s", topicRange.toString()), e);
                }
            }
        }
    }

    private String subscriptionNameFrom(TopicRange topicRange) {
        return topicRange.isFullRange() ? this.subscriptionName : this.subscriptionName + topicRange.getPulsarRange();
    }

    public MessageId getPositionFromSubscription(TopicRange topic, MessageId defaultPosition) {
        try {
            String subscriptionName = this.subscriptionNameFrom(topic);
            TopicStats topicStats = this.admin.topics().getStats(topic.getTopic());
            if (topicStats.getSubscriptions().containsKey(subscriptionName)) {
                SubscriptionStats subStats = topicStats.getSubscriptions().get(subscriptionName);
                if (subStats.getConsumers().size() != 0) {
                    throw new RuntimeException("Subscription been actively used by other consumers, in this situation, the exactly-once semantics cannot be guaranteed.");
                }
                String encodedSubName = URLEncoder.encode(subscriptionName, StandardCharsets.UTF_8.toString());
                ManagedLedgerInternalStats.CursorStats c = (ManagedLedgerInternalStats.CursorStats)this.admin.topics().getInternalStats((String)topic.getTopic()).cursors.get(encodedSubName);
                String[] ids = c.markDeletePosition.split(":", 2);
                long ledgerId = Long.parseLong(ids[0]);
                long entryIdInMarkDelete = Long.parseLong(ids[1]);
                long entryId = entryIdInMarkDelete == -1L ? -1L : entryIdInMarkDelete + 1L;
                int partitionIdx = TopicName.getPartitionIndex(topic.getTopic());
                return new MessageIdImpl(ledgerId, entryId, partitionIdx);
            }
            this.admin.topics().createSubscription(topic.getTopic(), subscriptionName, defaultPosition);
            return defaultPosition;
        }
        catch (UnsupportedEncodingException | PulsarAdminException e) {
            throw new RuntimeException("Failed to get stats for topic " + topic, e);
        }
    }

    public SchemaInfo getPulsarSchema(List<String> topics) throws IncompatibleSchemaException {
        HashSet schemas = new HashSet();
        if (topics.size() > 0) {
            topics.forEach(t -> schemas.add(this.getPulsarSchema((String)t)));
            if (schemas.size() != 1) {
                throw new IncompatibleSchemaException(String.format("Topics to read must share identical schema, however we got %d distinct schemas [%s]", schemas.size(), String.join((CharSequence)",", schemas.stream().map(Object::toString).collect(Collectors.toList()))), null);
            }
            return Iterables.getFirst(schemas, SchemaUtils.emptySchemaInfo());
        }
        return SchemaUtils.emptySchemaInfo();
    }

    public SchemaInfo getPulsarSchema(String topic) {
        try {
            return this.admin.schemas().getSchemaInfo(TopicName.get(topic).toString());
        }
        catch (Throwable e) {
            if (e instanceof PulsarAdminException && ((PulsarAdminException)e).getStatusCode() == 404) {
                return BytesSchema.of().getSchemaInfo();
            }
            throw new RuntimeException(String.format("Failed to get schema information for %s", TopicName.get(topic).toString()), e);
        }
    }

    public SerializableRange getRange() {
        return this.range;
    }

    public Set<TopicRange> getTopicPartitionRanges() throws PulsarAdminException {
        Set<String> topics = this.getTopicPartitions();
        return topics.stream().filter(t -> SourceSinkUtils.belongsTo(t, this.range, this.numParallelSubtasks, this.indexOfThisSubtask)).map(t -> new TopicRange((String)t, this.range.getPulsarRange())).collect(Collectors.toSet());
    }

    public Set<String> getTopicPartitions() throws PulsarAdminException {
        List<String> topics = this.getTopics();
        HashSet<String> allTopics = new HashSet<String>();
        for (String topic : topics) {
            int partNum = 1;
            try {
                partNum = this.admin.topics().getPartitionedTopicMetadata((String)topic).partitions;
            }
            catch (PulsarAdminException.NotFoundException e) {
                log.info("topic<{}> is not exit, auto create <{}> partition to <{}>", new Object[]{topic, partNum, topic});
                try {
                    this.createTopic(topic, partNum);
                }
                catch (PulsarAdminException.ConflictException conflictException) {
                    // empty catch block
                }
            }
            if (partNum == 0) {
                allTopics.add(topic);
                continue;
            }
            for (int i = 0; i < partNum; ++i) {
                allTopics.add(topic + "-partition-" + i);
            }
        }
        return allTopics;
    }

    private List<String> getTopics() throws PulsarAdminException {
        for (Map.Entry<String, String> e : this.caseInsensitiveParams.entrySet()) {
            if (!PulsarOptions.TOPIC_OPTION_KEYS.contains(e.getKey())) continue;
            switch (e.getKey()) {
                case "topic": {
                    return Collections.singletonList(TopicName.get(e.getValue()).toString());
                }
                case "topics": {
                    return Arrays.asList(e.getValue().split(",")).stream().filter(s2 -> !s2.isEmpty()).map(t -> TopicName.get(t).toString()).collect(Collectors.toList());
                }
                case "topicspattern": {
                    return this.getTopicsWithPattern(e.getValue());
                }
            }
            throw new IllegalArgumentException("Unknown pulsar topic option: " + e.getKey());
        }
        return Collections.emptyList();
    }

    private List<String> getTopicsWithPattern(String topicsPattern) throws PulsarAdminException {
        TopicName dest = TopicName.get(topicsPattern);
        List<String> allNonPartitionedTopics = this.getNonPartitionedTopics(dest.getNamespace());
        List<String> allPartitionedTopics = this.admin.topics().getPartitionedTopicList(dest.getNamespace());
        Pattern shortenedTopicsPattern = Pattern.compile(dest.toString().split("://")[1]);
        return Stream.concat(allNonPartitionedTopics.stream(), allPartitionedTopics.stream()).map(t -> TopicName.get(t).toString()).filter(t -> shortenedTopicsPattern.matcher(t.split("://")[1]).matches()).collect(Collectors.toList());
    }

    private List<String> getNonPartitionedTopics(String namespace) throws PulsarAdminException {
        return this.admin.topics().getList(namespace).stream().filter(t -> !TopicName.get(t).isPartitioned()).collect(Collectors.toList());
    }

    public MessageId getLastMessageId(String topic) {
        try {
            return this.admin.topics().getLastMessageId(topic);
        }
        catch (PulsarAdminException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean checkCursorAvailable(String topic, MessageIdImpl startMessageId) {
        try {
            PersistentTopicInternalStats stats = this.admin.topics().getInternalStats(topic);
            long ledgerId = startMessageId.getLedgerId();
            Optional<ManagedLedgerInternalStats.LedgerInfo> ledgerInfo = stats.ledgers.stream().filter(l -> l.ledgerId == ledgerId).findAny();
            return !ledgerInfo.filter(info -> startMessageId.getEntryId() > info.entries).isPresent();
        }
        catch (Exception e) {
            String message = MessageFormat.format("valid Cursor fail topic [{0}], messageId [{2}]", topic, startMessageId.toString());
            throw new RuntimeException(message, e);
        }
    }

    public void resetCursor(TopicRange topicRange, MessageId messageId) {
        try {
            this.admin.topics().resetCursor(topicRange.getTopic(), this.subscriptionNameFrom(topicRange), messageId);
        }
        catch (PulsarAdminException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public ClientConfigurationData getClientConf() {
        return this.clientConf;
    }

    public static class ClosedException
    extends Exception {
    }
}

