/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.pulsar.internal;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.impl.schema.AvroSchema;

public class AvroSer<T>
implements SerializationSchema<T> {
    private final Class<T> recordClazz;
    private transient AvroSchema<T> pulsarSchema;

    private AvroSer(Class<T> recordClazz) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null");
        this.recordClazz = recordClazz;
    }

    public static <T> AvroSer<T> of(Class<T> recordClazz) {
        return new AvroSer<T>(recordClazz);
    }

    public byte[] serialize(T message) {
        this.checkPulsarAvroSchemaInitialized();
        return this.pulsarSchema.encode(message);
    }

    private void checkPulsarAvroSchemaInitialized() {
        if (this.pulsarSchema != null) {
            return;
        }
        this.pulsarSchema = AvroSchema.of(this.recordClazz);
    }
}

