/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobufnative;

import com.google.protobuf.ByteString;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.EnumValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;

public class PulsarProtobufToRowDataConverters {
    public static ProtobufToRowDataConverter createRowConverter(RowType rowType) {
        ProtobufToRowDataConverter[] fieldConverters = (ProtobufToRowDataConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(PulsarProtobufToRowDataConverters::createNullableConverter).toArray(ProtobufToRowDataConverter[]::new);
        int arity = rowType.getFieldCount();
        return protobufObject -> {
            DynamicMessage record = (DynamicMessage)protobufObject;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                String fieldName = (String)rowType.getFieldNames().get(i);
                row.setField(i, fieldConverters[i].convert(record.getField(record.getDescriptorForType().findFieldByName(fieldName))));
            }
            return row;
        };
    }

    private static ProtobufToRowDataConverter createNullableConverter(LogicalType type) {
        ProtobufToRowDataConverter converter = PulsarProtobufToRowDataConverters.createConverter(type);
        return object -> {
            if (object == null) {
                return null;
            }
            return converter.convert(object);
        };
    }

    private static ProtobufToRowDataConverter createConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                return object -> object;
            }
            case CHAR: 
            case VARCHAR: {
                return object -> {
                    if (object instanceof EnumValue) {
                        return ((EnumValue)object).getName();
                    }
                    return StringData.fromString((String)object.toString());
                };
            }
            case BINARY: 
            case VARBINARY: {
                return PulsarProtobufToRowDataConverters::convertToBytes;
            }
            case ARRAY: {
                return PulsarProtobufToRowDataConverters.createArrayConverter((ArrayType)type);
            }
            case ROW: {
                return PulsarProtobufToRowDataConverters.createRowConverter((RowType)type);
            }
            case MAP: {
                return PulsarProtobufToRowDataConverters.createMapConverter((MapType)type);
            }
        }
        return object -> {
            throw new UnsupportedOperationException("Unsupported protobuf field type " + object.getClass() + " convert to flink type: " + type);
        };
    }

    private static ProtobufToRowDataConverter createArrayConverter(ArrayType arrayType) {
        ProtobufToRowDataConverter elementConverter = PulsarProtobufToRowDataConverters.createNullableConverter(arrayType.getElementType());
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        return protobufObject -> {
            List list = (List)protobufObject;
            int length = list.size();
            Object[] array = (Object[])Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = elementConverter.convert(list.get(i));
            }
            return new GenericArrayData(array);
        };
    }

    private static ProtobufToRowDataConverter createMapConverter(MapType type) {
        ProtobufToRowDataConverter keyConverter = PulsarProtobufToRowDataConverters.createConverter(type.getKeyType());
        ProtobufToRowDataConverter valueConverter = PulsarProtobufToRowDataConverters.createNullableConverter(type.getValueType());
        return object -> {
            Map map = (Map)object;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = keyConverter.convert(entry.getKey());
                Object value = valueConverter.convert(entry.getValue());
                result.put(key, value);
            }
            return new GenericMapData(result);
        };
    }

    private static byte[] convertToBytes(Object object) {
        if (object instanceof ByteString) {
            return ((ByteString)object).toByteArray();
        }
        return (byte[])object;
    }

    @FunctionalInterface
    public static interface ProtobufToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

