/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.serialize;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.formats.protobuf.PbCodegenAppender;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.deserialize.ProtoToRowConverter;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializeFactory;
import org.apache.flink.formats.protobuf.serialize.PbCodegenSerializer;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.RowType;
import org.codehaus.janino.ScriptEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowToProtoConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoToRowConverter.class);
    private ScriptEvaluator se;

    public RowToProtoConverter(String messageClassName, RowType rowType) throws PbCodegenException {
        try {
            Descriptors.Descriptor descriptor = PbFormatUtils.getDescriptor(messageClassName);
            this.se = new ScriptEvaluator();
            this.se.setParameters(new String[]{"rowData"}, new Class[]{RowData.class});
            this.se.setReturnType(AbstractMessage.class);
            this.se.setDefaultImports(new String[]{AbstractMessage.class.getName(), Descriptors.class.getName(), RowData.class.getName(), ArrayData.class.getName(), StringData.class.getName(), ByteString.class.getName(), List.class.getName(), ArrayList.class.getName(), Map.class.getName(), HashMap.class.getName()});
            StringBuilder sb = new StringBuilder();
            sb.append("AbstractMessage message = null;\n");
            PbCodegenSerializer codegenSer = PbCodegenSerializeFactory.getPbCodegenTopRowSer(descriptor, rowType);
            String genCode = codegenSer.codegen("message", "rowData");
            sb.append(genCode);
            sb.append("return message;\n");
            String code = sb.toString();
            String printCode = PbCodegenAppender.printWithLineNumber(code);
            LOG.debug("Protobuf decode codegen: \n" + printCode);
            this.se.cook(code);
        }
        catch (Exception ex) {
            throw new PbCodegenException(ex);
        }
    }

    public byte[] convertRowToProtoBinary(RowData rowData) throws Exception {
        AbstractMessage message = (AbstractMessage)this.se.evaluate(new Object[]{rowData});
        return message.toByteArray();
    }
}

