/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatUtils;
import org.apache.flink.formats.protobuf.PbSchemaValidator;
import org.apache.flink.formats.protobuf.deserialize.ProtoToRowConverter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class PbRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(PbRowDataDeserializationSchema.class);
    private static final long serialVersionUID = -4040917522067315718L;
    private final RowType rowType;
    private final TypeInformation<RowData> resultTypeInfo;
    private final String messageClassName;
    private final boolean ignoreParseErrors;
    private final boolean readDefaultValues;
    private transient ProtoToRowConverter protoToRowConverter;

    public PbRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, String messageClassName, boolean ignoreParseErrors, boolean readDefaultValues) {
        Preconditions.checkNotNull((Object)rowType, (String)"Type information");
        this.rowType = rowType;
        this.resultTypeInfo = resultTypeInfo;
        this.messageClassName = messageClassName;
        this.ignoreParseErrors = ignoreParseErrors;
        this.readDefaultValues = readDefaultValues;
        new PbSchemaValidator(PbFormatUtils.getDescriptor(messageClassName), rowType).validate();
        try {
            this.protoToRowConverter = new ProtoToRowConverter(messageClassName, rowType, readDefaultValues);
        }
        catch (PbCodegenException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.protoToRowConverter = new ProtoToRowConverter(this.messageClassName, this.rowType, this.readDefaultValues);
    }

    public RowData deserialize(byte[] message) throws IOException {
        try {
            return this.protoToRowConverter.convertProtoBinaryToRow(message);
        }
        catch (Throwable t) {
            if (this.ignoreParseErrors) {
                return null;
            }
            LOG.error("Failed to deserialize PB object.", t);
            throw new IOException("Failed to deserialize PB object.", t);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PbRowDataDeserializationSchema that = (PbRowDataDeserializationSchema)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && this.readDefaultValues == that.readDefaultValues && Objects.equals(this.rowType, that.rowType) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo) && Objects.equals(this.messageClassName, that.messageClassName);
    }

    public int hashCode() {
        return Objects.hash(this.rowType, this.resultTypeInfo, this.messageClassName, this.ignoreParseErrors, this.readDefaultValues);
    }
}

