/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;

public class PbSchemaValidator {
    private Descriptors.Descriptor descriptor;
    private RowType rowType;
    private Map<Descriptors.FieldDescriptor.JavaType, List<LogicalTypeRoot>> typeMatchMap = new HashMap<Descriptors.FieldDescriptor.JavaType, List<LogicalTypeRoot>>();

    public PbSchemaValidator(Descriptors.Descriptor descriptor, RowType rowType) {
        this.descriptor = descriptor;
        this.rowType = rowType;
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.BOOLEAN, Collections.singletonList(LogicalTypeRoot.BOOLEAN));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.BYTE_STRING, Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.DOUBLE, Collections.singletonList(LogicalTypeRoot.DOUBLE));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.FLOAT, Collections.singletonList(LogicalTypeRoot.FLOAT));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.ENUM, Arrays.asList(LogicalTypeRoot.VARCHAR, LogicalTypeRoot.CHAR));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.STRING, Arrays.asList(LogicalTypeRoot.VARCHAR, LogicalTypeRoot.CHAR));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.INT, Collections.singletonList(LogicalTypeRoot.INTEGER));
        this.typeMatchMap.put(Descriptors.FieldDescriptor.JavaType.LONG, Collections.singletonList(LogicalTypeRoot.BIGINT));
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public RowType getRowType() {
        return this.rowType;
    }

    public void setRowType(RowType rowType) {
        this.rowType = rowType;
    }

    public void validate() {
        this.validateTypeMatch(this.descriptor, this.rowType);
        if (!this.descriptor.getFile().getOptions().getJavaPackage().equals(this.descriptor.getFile().getPackage())) {
            throw new IllegalArgumentException("java_package and package must be the same in proto definition");
        }
        if (!this.descriptor.getFile().getOptions().getJavaMultipleFiles()) {
            throw new IllegalArgumentException("java_multiple_files must set to true");
        }
    }

    public void validateTypeMatch(Descriptors.Descriptor descriptor, RowType rowType) {
        rowType.getFields().forEach(rowField -> {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(rowField.getName());
            if (null == fieldDescriptor) {
                throw new ValidationException("Column " + rowField.getName() + " does not exists in definition of proto class.");
            }
            this.validateTypeMatch(fieldDescriptor, rowField.getType());
        });
    }

    public void validateTypeMatch(Descriptors.FieldDescriptor fd, LogicalType logicalType) {
        if (!fd.isRepeated()) {
            if (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                this.validateSimpleType(fd, logicalType.getTypeRoot());
            } else {
                this.validateTypeMatch(fd.getMessageType(), (RowType)logicalType);
            }
        } else if (fd.isMapField()) {
            MapType mapType = (MapType)logicalType;
            this.validateSimpleType(fd.getMessageType().findFieldByName("key"), mapType.getKeyType().getTypeRoot());
            this.validateTypeMatch(fd.getMessageType().findFieldByName("value"), mapType.getValueType());
        } else {
            ArrayType arrayType = (ArrayType)logicalType;
            if (fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                this.validateTypeMatch(fd.getMessageType(), (RowType)arrayType.getElementType());
            } else {
                this.validateSimpleType(fd, arrayType.getElementType().getTypeRoot());
            }
        }
    }

    private void validateSimpleType(Descriptors.FieldDescriptor fd, LogicalTypeRoot logicalTypeRoot) {
        if (!this.typeMatchMap.containsKey(fd.getJavaType())) {
            throw new ValidationException("Unsupported protobuf java type: " + fd.getJavaType());
        }
        if (this.typeMatchMap.get(fd.getJavaType()).stream().noneMatch(x -> x == logicalTypeRoot)) {
            throw new ValidationException("Protobuf field type does not match column type, " + fd.getJavaType() + "(pb) is not compatible of " + logicalTypeRoot + "(table DDL)");
        }
    }
}

