/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.pulsar.source.AbstractPartition;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.SplitSchedulingStrategy;
import org.apache.flink.connector.pulsar.source.StartOffsetInitializer;
import org.apache.flink.connector.pulsar.source.StopCondition;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumeratorState;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.util.ComponentClosingUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSourceEnumerator
implements SplitEnumerator<PulsarPartitionSplit, PulsarSourceEnumeratorState> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSourceEnumerator.class);
    private final PulsarSubscriber subscriber;
    private final StartOffsetInitializer startOffsetInitializer;
    private final StopCondition stopCondition;
    private final PulsarAdmin pulsarAdmin;
    private final Configuration configuration;
    private final long partitionDiscoveryIntervalMs;
    private final SplitEnumeratorContext<PulsarPartitionSplit> context;
    private final Set<AbstractPartition> discoveredPartitions;
    private final Map<Integer, List<PulsarPartitionSplit>> readerIdToSplitAssignments;
    private final Map<Integer, List<PulsarPartitionSplit>> pendingPartitionSplitAssignment;
    private boolean noMoreNewPartitionSplits = false;
    private SplitSchedulingStrategy splitSchedulingStrategy;

    public PulsarSourceEnumerator(PulsarSubscriber subscriber, StartOffsetInitializer startOffsetInitializer, StopCondition stopCondition, PulsarAdmin pulsarAdmin, Configuration configuration, SplitEnumeratorContext<PulsarPartitionSplit> context, Map<Integer, List<PulsarPartitionSplit>> currentSplitsAssignments, SplitSchedulingStrategy splitSchedulingStrategy) {
        this.subscriber = subscriber;
        this.subscriber.setContext(context);
        this.startOffsetInitializer = startOffsetInitializer;
        this.stopCondition = stopCondition;
        this.pulsarAdmin = pulsarAdmin;
        this.configuration = configuration;
        this.context = context;
        this.splitSchedulingStrategy = splitSchedulingStrategy;
        this.discoveredPartitions = new HashSet<AbstractPartition>();
        this.readerIdToSplitAssignments = new HashMap<Integer, List<PulsarPartitionSplit>>(currentSplitsAssignments);
        this.readerIdToSplitAssignments.forEach((reader, splits) -> splits.forEach(s2 -> this.discoveredPartitions.add(s2.getPartition())));
        this.pendingPartitionSplitAssignment = new HashMap<Integer, List<PulsarPartitionSplit>>();
        this.partitionDiscoveryIntervalMs = (Long)configuration.get(PulsarSourceOptions.PARTITION_DISCOVERY_INTERVAL_MS);
    }

    public void start() {
        if (this.partitionDiscoveryIntervalMs > 0L) {
            this.context.callAsync(this::discoverAndInitializePartitionSplit, this::handlePartitionSplitChanges, 0L, this.partitionDiscoveryIntervalMs);
        } else {
            this.context.callAsync(this::discoverAndInitializePartitionSplit, this::handlePartitionSplitChanges);
        }
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
    }

    public void addSplitsBack(List<PulsarPartitionSplit> splits, int subtaskId) {
        this.splitSchedulingStrategy.addSplitsBack(this.pendingPartitionSplitAssignment, splits, subtaskId, this.context.currentParallelism());
        this.assignPendingPartitionSplits();
    }

    public void addReader(int subtaskId) {
        LOG.debug("Adding reader {}.", (Object)subtaskId);
        this.assignPendingPartitionSplits();
    }

    public PulsarSourceEnumeratorState snapshotState(long l) throws Exception {
        return new PulsarSourceEnumeratorState(this.readerIdToSplitAssignments);
    }

    public void close() {
        long closeTimeoutMs = (Long)this.configuration.get(PulsarSourceOptions.CLOSE_TIMEOUT_MS);
        this.close(closeTimeoutMs).ifPresent(t -> LOG.warn("Encountered error when closing PulsarSourceEnumerator", t));
    }

    @VisibleForTesting
    Optional<Throwable> close(long timeoutMs) {
        return ComponentClosingUtils.closeWithTimeout("PulsarSourceEnumerator", (ThrowingRunnable<Exception>)((ThrowingRunnable)() -> this.pulsarAdmin.close()), timeoutMs);
    }

    private PartitionSplitChange discoverAndInitializePartitionSplit() throws IOException, InterruptedException, PulsarAdminException {
        PulsarSubscriber.PartitionChange partitionChange = this.subscriber.getPartitionChanges(this.pulsarAdmin, Collections.unmodifiableSet(this.discoveredPartitions));
        this.discoveredPartitions.addAll(partitionChange.getNewPartitions());
        List partitionSplits = partitionChange.getNewPartitions().stream().map(partition -> new PulsarPartitionSplit((AbstractPartition)partition, this.startOffsetInitializer, this.stopCondition)).collect(Collectors.toList());
        return new PartitionSplitChange(partitionSplits, partitionChange.getRemovedPartitions());
    }

    private void handlePartitionSplitChanges(PartitionSplitChange partitionSplitChange, Throwable t) {
        if (t != null) {
            throw new FlinkRuntimeException("Failed to handle partition splits change due to ", t);
        }
        if (this.partitionDiscoveryIntervalMs < 0L) {
            this.noMoreNewPartitionSplits = true;
        }
        this.addPartitionSplitChangeToPendingAssignments(partitionSplitChange.newPartitionSplits);
        this.assignPendingPartitionSplits();
    }

    private void addPartitionSplitChangeToPendingAssignments(Collection<PulsarPartitionSplit> newPartitionSplits) {
        int numReaders = this.context.currentParallelism();
        for (PulsarPartitionSplit split : newPartitionSplits) {
            this.pendingPartitionSplitAssignment.computeIfAbsent(this.splitSchedulingStrategy.getIndexOfReader(numReaders, split), r -> new ArrayList()).add(split);
        }
        LOG.debug("Assigned {} to {} readers.", newPartitionSplits, (Object)numReaders);
    }

    private void assignPendingPartitionSplits() {
        HashMap<Integer, List> incrementalAssignment = new HashMap<Integer, List>();
        this.pendingPartitionSplitAssignment.forEach((ownerReader, pendingSplits) -> {
            if (!pendingSplits.isEmpty() && this.context.registeredReaders().containsKey(ownerReader)) {
                incrementalAssignment.computeIfAbsent((Integer)ownerReader, r -> new ArrayList()).addAll(pendingSplits);
            }
        });
        if (incrementalAssignment.isEmpty()) {
            return;
        }
        this.context.assignSplits(new SplitsAssignment(incrementalAssignment));
        incrementalAssignment.forEach((readerOwner, newPartitionSplits) -> {
            this.readerIdToSplitAssignments.computeIfAbsent((Integer)readerOwner, r -> new ArrayList()).addAll(newPartitionSplits);
            this.pendingPartitionSplitAssignment.remove(readerOwner);
            if (this.noMoreNewPartitionSplits) {
                this.context.signalNoMoreSplits(readerOwner.intValue());
            }
        });
    }

    public static class PartitionSplitChange {
        private final List<PulsarPartitionSplit> newPartitionSplits;
        private final Set<AbstractPartition> removedPartitions;

        private PartitionSplitChange(List<PulsarPartitionSplit> newPartitionSplits, Set<AbstractPartition> removedPartitions) {
            this.newPartitionSplits = newPartitionSplits;
            this.removedPartitions = removedPartitions;
        }
    }
}

