/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Base64;
import java.util.HashMap;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.util.TemporalConversions;
import org.apache.inlong.sort.cdc.mysql.table.MySqlReadableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldFieldMetadataConverter
implements MetadataConverter {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(OldFieldMetadataConverter.class);
    private static final DateTimeFormatter SQL_TIME_FORMAT = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter SQL_TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(SQL_TIME_FORMAT).toFormatter();
    private static final DateTimeFormatter SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(SQL_TIME_FORMAT).appendPattern("'Z'").toFormatter();
    private final ZoneId serverTimeZone;
    private final MetadataConverter converter;
    private final StringConverter toStringConverter;
    private final String[] fieldNames;
    private final StringConverter[] stringConverters;

    public OldFieldMetadataConverter(RowType rowType, ZoneId serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
        this.converter = MySqlReadableMetadata.OLD.getConverter();
        this.toStringConverter = new ToStringConverter();
        this.fieldNames = rowType.getFieldNames().toArray(new String[0]);
        this.stringConverters = (StringConverter[])rowType.getChildren().stream().map(this::createConverter).toArray(StringConverter[]::new);
    }

    @Override
    public Object read(SourceRecord record) {
        Object obj = this.converter.read(record);
        if (obj == null) {
            return null;
        }
        Struct value = (Struct)record.value();
        Schema valueSchema = record.valueSchema();
        Schema beforeSchema = valueSchema.field("before").schema();
        Struct before = value.getStruct("before");
        HashMap<StringData, StringData> oldData = new HashMap<StringData, StringData>();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            StringConverter stringConverter = this.stringConverters[i];
            Field field = beforeSchema.field(fieldName);
            if (field == null) {
                oldData.put(StringData.fromString((String)fieldName), null);
                continue;
            }
            Object fieldValue = before.get(field);
            Schema fieldSchema = field.schema();
            StringData strFieldValue = null;
            try {
                String str = stringConverter.convert(fieldValue, fieldSchema);
                strFieldValue = StringData.fromString((String)str);
            }
            catch (Exception e) {
                LOG.error("Failed to convert value " + fieldValue + " (" + fieldSchema.name() + ") to string.");
            }
            oldData.put(StringData.fromString((String)fieldName), strFieldValue);
        }
        return new GenericArrayData(new Object[]{new GenericMapData(oldData)});
    }

    private StringConverter createConverter(LogicalType type) {
        return this.wrapIntoNullableConverter(this.createNotNullConverter(type));
    }

    private StringConverter createNotNullConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return new StringConverter(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String convert(Object dbzObj, Schema schema) throws Exception {
                        return null;
                    }
                };
            }
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return this.toStringConverter;
            }
            case DATE: {
                return this.createDateConverter();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this.createTimeConverter();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return this.createTimestampConverter();
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.createLocalTimeZoneTimestampConverter();
            }
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: {
                return this.toStringConverter;
            }
            case BINARY: 
            case VARBINARY: {
                return this.createBinaryConverter();
            }
            case DECIMAL: {
                return this.createDecimalConverter((DecimalType)type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private StringConverter createDateConverter() {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                return DateTimeFormatter.ISO_LOCAL_DATE.format(TemporalConversions.toLocalDate(dbzObj));
            }
        };
    }

    private StringConverter createTimeConverter() {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                int millisecond = this.toMillisecond(dbzObj, schema);
                LocalTime time = LocalTime.ofSecondOfDay((long)millisecond / 1000L);
                return SQL_TIME_FORMAT.format(time);
            }

            private int toMillisecond(Object dbzObj, Schema schema) {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.MicroTime": {
                            return (int)((Long)dbzObj / 1000L);
                        }
                        case "io.debezium.time.NanoTime": {
                            return (int)((Long)dbzObj / 1000000L);
                        }
                    }
                } else if (dbzObj instanceof Integer) {
                    return (Integer)dbzObj;
                }
                return TemporalConversions.toLocalTime(dbzObj).toSecondOfDay() * 1000;
            }
        };
    }

    private StringConverter createTimestampConverter() {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                return SQL_TIMESTAMP_FORMAT.format(this.toTimestampData(dbzObj, schema).toLocalDateTime());
            }

            private TimestampData toTimestampData(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj instanceof Long) {
                    switch (schema.name()) {
                        case "io.debezium.time.Timestamp": {
                            return TimestampData.fromEpochMillis((long)((Long)dbzObj));
                        }
                        case "io.debezium.time.MicroTimestamp": {
                            long micro = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(micro / 1000L), (int)((int)(micro % 1000L * 1000L)));
                        }
                        case "io.debezium.time.NanoTimestamp": {
                            long nano = (Long)dbzObj;
                            return TimestampData.fromEpochMillis((long)(nano / 1000000L), (int)((int)(nano % 1000000L)));
                        }
                    }
                }
                LocalDateTime localDateTime = TemporalConversions.toLocalDateTime(dbzObj, OldFieldMetadataConverter.this.serverTimeZone);
                return TimestampData.fromLocalDateTime((LocalDateTime)localDateTime);
            }
        };
    }

    private StringConverter createLocalTimeZoneTimestampConverter() {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                return SQL_TIMESTAMP_WITH_LOCAL_TIMEZONE_FORMAT.format(this.toTimestampData(dbzObj, schema).toInstant().atOffset(ZoneOffset.UTC));
            }

            private TimestampData toTimestampData(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant instant = Instant.parse(str);
                    return TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.ofInstant(instant, OldFieldMetadataConverter.this.serverTimeZone));
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        };
    }

    private StringConverter createBinaryConverter() {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                Base64.Encoder base64Encoder = Base64.getEncoder();
                return base64Encoder.encodeToString(this.convertToBinary(dbzObj, schema));
            }

            private byte[] convertToBinary(Object dbzObj, Schema schema) {
                if (dbzObj instanceof byte[]) {
                    return (byte[])dbzObj;
                }
                if (dbzObj instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)dbzObj;
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                throw new UnsupportedOperationException("Unsupported BYTES value type: " + dbzObj.getClass().getSimpleName());
            }
        };
    }

    private StringConverter createDecimalConverter(DecimalType decimalType) {
        final int precision = decimalType.getPrecision();
        final int scale = decimalType.getScale();
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                BigDecimal bigDecimal;
                if (dbzObj instanceof byte[]) {
                    bigDecimal = Decimal.toLogical(schema, (byte[])dbzObj);
                } else if (dbzObj instanceof String) {
                    bigDecimal = new BigDecimal((String)dbzObj);
                } else if (dbzObj instanceof Double) {
                    bigDecimal = BigDecimal.valueOf((Double)dbzObj);
                } else if ("io.debezium.data.VariableScaleDecimal".equals(schema.name())) {
                    SpecialValueDecimal decimal = VariableScaleDecimal.toLogical((Struct)dbzObj);
                    bigDecimal = decimal.getDecimalValue().orElse(BigDecimal.ZERO);
                } else {
                    bigDecimal = new BigDecimal(dbzObj.toString());
                }
                return DecimalData.fromBigDecimal((BigDecimal)bigDecimal, (int)precision, (int)scale).toBigDecimal().toString();
            }
        };
    }

    private StringConverter wrapIntoNullableConverter(final StringConverter converter) {
        return new StringConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public String convert(Object dbzObj, Schema schema) throws Exception {
                if (dbzObj == null) {
                    return null;
                }
                return converter.convert(dbzObj, schema);
            }
        };
    }

    private static class ToStringConverter
    implements StringConverter {
        private static final long serialVersionUID = 1L;

        private ToStringConverter() {
        }

        @Override
        public String convert(Object dbzObj, Schema schema) throws Exception {
            return dbzObj.toString();
        }
    }

    @FunctionalInterface
    private static interface StringConverter
    extends Serializable {
        public String convert(Object var1, Schema var2) throws Exception;
    }
}

