/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.data.Envelope;
import io.debezium.relational.Table;
import io.debezium.relational.history.TableChanges;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;
import org.apache.inlong.sort.formats.json.canal.CanalJson;
import org.apache.inlong.sort.formats.json.debezium.DebeziumJson;

public enum MySqlReadableMetadata {
    TABLE_NAME("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)MySqlReadableMetadata.getMetaData(record, "table"));
        }
    }),
    DATABASE_NAME("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)MySqlReadableMetadata.getMetaData(record, "db"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    DATA_DEFAULT("meta.data", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return MySqlReadableMetadata.getCanalData(record, (GenericRowData)rowData, tableSchema);
        }
    }),
    DATA("meta.data_canal", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            return MySqlReadableMetadata.getCanalData(record, (GenericRowData)rowData, tableSchema);
        }
    }),
    DATA_DEBEZIUM("meta.data_debezium", DataTypes.STRING(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema, RowData rowData) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            GenericRowData data = (GenericRowData)rowData;
            Map field = (Map)data.getField(0);
            DebeziumJson.Source source = DebeziumJson.Source.builder().db(MySqlReadableMetadata.getMetaData(record, "db")).table(MySqlReadableMetadata.getMetaData(record, "table")).name(sourceStruct.getString("name")).sqlType(MySqlReadableMetadata.getSqlType(tableSchema)).pkNames(MySqlReadableMetadata.getPkNames(tableSchema)).mysqlType(MySqlReadableMetadata.getMysqlType(tableSchema)).build();
            DebeziumJson debeziumJson = DebeziumJson.builder().after(field).source(source).tsMs(sourceStruct.getInt64("ts_ms").longValue()).op(MySqlReadableMetadata.getDebeziumOpType(record)).tableChange(tableSchema).build();
            try {
                return StringData.fromString((String)OBJECT_MAPPER.writeValueAsString((Object)debeziumJson));
            }
            catch (Exception e) {
                throw new IllegalStateException("exception occurs when get meta data", e);
            }
        }
    }),
    META_TABLE_NAME("meta.table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)MySqlReadableMetadata.getMetaData(record, "table"));
        }
    }),
    META_DATABASE_NAME("meta.database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)MySqlReadableMetadata.getMetaData(record, "db"));
        }
    }),
    META_OP_TS("meta.op_ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            Struct sourceStruct = messageStruct.getStruct("source");
            return TimestampData.fromEpochMillis((long)((Long)sourceStruct.get("ts_ms")));
        }
    }),
    OP_TYPE("meta.op_type", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)MySqlReadableMetadata.getCanalOpType(record));
        }
    }),
    BATCH_ID("meta.batch_id", (DataType)DataTypes.BIGINT().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;
        private long id = 0L;

        @Override
        public Object read(SourceRecord record) {
            return this.id++;
        }
    }),
    IS_DDL("meta.is_ddl", (DataType)DataTypes.BOOLEAN().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return false;
        }
    }),
    OLD("meta.update_before", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Envelope.Operation op = Envelope.operationFor(record);
            if (op != Envelope.Operation.UPDATE) {
                return null;
            }
            return record;
        }
    }),
    MYSQL_TYPE("meta.mysql_type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.STRING().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            HashMap mysqlType = new HashMap();
            Table table = tableSchema.getTable();
            table.columns().forEach(column -> mysqlType.put(StringData.fromString((String)column.name()), StringData.fromString((String)String.format("%s(%d)", column.typeName(), column.length()))));
            return new GenericMapData(mysqlType);
        }
    }),
    PK_NAMES("meta.pk_names", (DataType)DataTypes.ARRAY((DataType)((DataType)DataTypes.STRING().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            return new GenericArrayData(tableSchema.getTable().primaryKeyColumnNames().stream().map(StringData::fromString).toArray());
        }
    }),
    SQL("meta.sql", (DataType)DataTypes.STRING().nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return StringData.fromString((String)"");
        }
    }),
    SQL_TYPE("meta.sql_type", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.INT().nullable())).nullable(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            return null;
        }

        @Override
        public Object read(SourceRecord record, @Nullable TableChanges.TableChange tableSchema) {
            if (tableSchema == null) {
                return null;
            }
            HashMap mysqlType = new HashMap();
            Table table = tableSchema.getTable();
            table.columns().forEach(column -> mysqlType.put(StringData.fromString((String)column.name()), column.jdbcType()));
            return new GenericMapData(mysqlType);
        }
    }),
    TS("meta.ts", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        @Override
        public Object read(SourceRecord record) {
            Struct messageStruct = (Struct)record.value();
            return TimestampData.fromEpochMillis((long)((Long)messageStruct.get("ts_ms")));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;
    private static final ObjectMapper OBJECT_MAPPER;

    private static StringData getCanalData(SourceRecord record, GenericRowData rowData, TableChanges.TableChange tableSchema) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        String tableName = MySqlReadableMetadata.getMetaData(record, "table");
        String databaseName = MySqlReadableMetadata.getMetaData(record, "db");
        long opTs = (Long)sourceStruct.get("ts_ms");
        long ts = (Long)messageStruct.get("ts_ms");
        GenericRowData data = rowData;
        Map field = (Map)data.getField(0);
        ArrayList<Map> dataList = new ArrayList<Map>();
        dataList.add(field);
        CanalJson canalJson = CanalJson.builder().data(dataList).database(databaseName).sql("").es(opTs).isDdl(false).pkNames(MySqlReadableMetadata.getPkNames(tableSchema)).mysqlType(MySqlReadableMetadata.getMysqlType(tableSchema)).table(tableName).ts(ts).type(MySqlReadableMetadata.getCanalOpType(record)).sqlType(MySqlReadableMetadata.getSqlType(tableSchema)).build();
        try {
            return StringData.fromString((String)OBJECT_MAPPER.writeValueAsString((Object)canalJson));
        }
        catch (Exception e) {
            throw new IllegalStateException("exception occurs when get meta data", e);
        }
    }

    private MySqlReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    private static String getCanalOpType(SourceRecord record) {
        Envelope.Operation op = Envelope.operationFor(record);
        String opType = op == Envelope.Operation.CREATE || op == Envelope.Operation.READ ? "INSERT" : (op == Envelope.Operation.DELETE ? "DELETE" : "UPDATE");
        return opType;
    }

    private static String getDebeziumOpType(SourceRecord record) {
        Envelope.Operation op = Envelope.operationFor(record);
        String opType = op == Envelope.Operation.CREATE || op == Envelope.Operation.READ ? "c" : (op == Envelope.Operation.DELETE ? "d" : "u");
        return opType;
    }

    private static List<String> getPkNames(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        return tableSchema.getTable().primaryKeyColumnNames();
    }

    public static Map<String, String> getMysqlType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, String> mysqlType = new LinkedHashMap<String, String>();
        Table table = tableSchema.getTable();
        table.columns().forEach(column -> mysqlType.put(column.name(), String.format("%s(%d)", column.typeName(), column.length())));
        return mysqlType;
    }

    public static Map<String, Integer> getSqlType(@Nullable TableChanges.TableChange tableSchema) {
        if (tableSchema == null) {
            return null;
        }
        LinkedHashMap<String, Integer> sqlType = new LinkedHashMap<String, Integer>();
        Table table = tableSchema.getTable();
        table.columns().forEach(column -> sqlType.put(column.name(), column.jdbcType()));
        return sqlType;
    }

    public static String getMetaData(SourceRecord record, String tableNameKey) {
        Struct messageStruct = (Struct)record.value();
        Struct sourceStruct = messageStruct.getStruct("source");
        return sourceStruct.getString(tableNameKey);
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

